package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxQueryRunner;

public abstract class AbstractBeanUpdateTemplate<E> extends
		AbstractBeanQueryTemplate<E> implements BeanUpdateTemplate<E> {


	protected int[] executeBatch(String sql, Object[][] params)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.batch(getConnection(), sql, params);
	}

	protected int executeUpdate(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.update(getConnection(), query);
	}

	protected int[] executeUpdates(List<Query> queries) throws SQLException {
		int[] result = new int[queries.size()];
		SxQueryRunner runner = new SxQueryRunner();
		for (int i = 0; i < queries.size(); i++) {
			result[i] = runner.update(getConnection(), queries.get(i));
		}
		return result;
	}


	protected abstract QueryFactory getInsertFactory();

	protected abstract QueryFactory getUpdateFactory();

	public int insert(E bean) throws SQLException {
		Query q = getInsertFactory().toQuery(bean);
		return executeUpdate(q);
	}

	public int[] insert(Collection<E> beans) throws SQLException {
		List<Query> queries = new ArrayList<Query>();
		for (E bean : beans) {
			Query q = getInsertFactory().toQuery(bean);
			queries.add(q);
		}
		return executeUpdates(queries);
	}

	public int update(E bean) throws SQLException {
		Query q = getUpdateFactory().toQuery(bean);
		return executeUpdate(q);
	}

	public int[] update(Collection<E> beans) throws SQLException {
		List<Query> queries = new ArrayList<Query>();
		for (E bean : beans) {
			Query q = getUpdateFactory().toQuery(bean);
			queries.add(q);
		}
		return executeUpdates(queries);
	}

	public int[] insertBatch(Collection<E> beans) throws SQLException {
		QueryFactory insertFactory = getInsertFactory();
		Object[][] batchParams = new Object[beans.size()][];
		int i = 0;
		for (E bean : beans) {
			batchParams[i++] = insertFactory.toBindParameters(bean);
		}
		return executeBatch(insertFactory.getSql(), batchParams);
	}

	public int[] updateBatch(Collection<E> beans) throws SQLException {
		QueryFactory updateFactory = getUpdateFactory();
		Object[][] batchParams = new Object[beans.size()][];
		int i = 0;
		for (E bean : beans) {
			batchParams[i++] = updateFactory.toBindParameters(bean);
		}
		return executeBatch(updateFactory.getSql(), batchParams);
	}

}
