/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryBuilder;
import jp.sourceforge.sxdbutils.query.SimpleQueryBuilder;
import jp.sourceforge.sxdbutils.util.OthersUtils;
import jp.sourceforge.sxdbutils.util.QueryUtil;

public class SimpleUpdateBuilder
implements QueryBuilder {
    private final String tableName;
    private Map updateColumnMap = new LinkedHashMap();
    private Map whereColumnMap = new LinkedHashMap();
    private String versionColumnName;
    private Object versionColumnValue;

    public SimpleUpdateBuilder addUpdateColumn(String columnName, Object value) {
        this.updateColumnMap.put(columnName, value);
        return this;
    }

    public SimpleUpdateBuilder addUpdateColumn(Map columnMap) {
        this.updateColumnMap.putAll(columnMap);
        return this;
    }

    public SimpleUpdateBuilder addWhereColumn(String columnName, Object value) {
        this.whereColumnMap.put(columnName, value);
        return this;
    }

    public SimpleUpdateBuilder setVersionColumn(String columnName, Object value) {
        this.versionColumnName = columnName;
        this.versionColumnValue = value;
        return this;
    }

    public SimpleUpdateBuilder(String tableName) {
        this.tableName = tableName;
    }

    public Query toQuery() {
        SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
        builder.append("update ").append(this.tableName).append(" set ");
        boolean colflg = false;
        Iterator iterator = this.updateColumnMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.versionColumnName != null && this.versionColumnName.equalsIgnoreCase((String)entry.getKey())) continue;
            if (colflg) {
                builder.append(',');
            }
            colflg = true;
            builder.append((String)entry.getKey()).append("=?").bind(entry.getValue());
        }
        if (OthersUtils.isNotEmpty(this.versionColumnName)) {
            if (colflg) {
                builder.append(',');
            }
            builder.append(this.versionColumnName).append("=?").bind(QueryUtil.getNextVersion(this.versionColumnValue));
        }
        builder.append(" where ");
        boolean whereflg = false;
        Iterator iterator2 = this.whereColumnMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (whereflg) {
                builder.append(" and ");
            }
            whereflg = true;
            builder.append((String)entry.getKey()).append("=?").bind(entry.getValue());
        }
        if (OthersUtils.isNotEmpty(this.versionColumnName) && this.versionColumnValue != null) {
            if (whereflg) {
                builder.append(" and ");
            }
            builder.append(this.versionColumnName).append("=?").bind(this.versionColumnValue);
        }
        return builder.toQuery();
    }
}

