/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.bean.ColumnNameMapping;
import jp.sourceforge.sxdbutils.bean.ColumnProperty;
import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.query.BeanQueryFactory;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;
import org.apache.commons.lang.ClassUtils;

public class BeanQueryFactoryBuilder {
    private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();
    protected String tableName;
    protected final Class beanClass;
    protected final NameMapping nameMapping;
    protected Set updateKeyColumnSet;
    protected Map columnTypeMap = new HashMap();
    protected Set excludeColumns = new HashSet();

    public BeanQueryFactoryBuilder(Class beanClass) {
        this(beanClass, DEFAULT_NAME_MAPPING);
    }

    public BeanQueryFactoryBuilder(Class beanClass, NameMapping nameMapping) {
        this.beanClass = beanClass;
        this.nameMapping = nameMapping;
        this.tableName = ClassUtils.getShortClassName((Class)beanClass);
    }

    public BeanQueryFactoryBuilder excludeColumn(String excludeColumn) {
        this.excludeColumns.add(excludeColumn.toLowerCase());
        return this;
    }

    public BeanQueryFactoryBuilder excludeColumns(String[] excludeColumns) {
        for (int i = 0; i < excludeColumns.length; ++i) {
            this.excludeColumn(excludeColumns[i]);
        }
        return this;
    }

    public BeanQueryFactoryBuilder excludeColumns(List excludeColumns) {
        for (int i = 0; i < excludeColumns.size(); ++i) {
            this.excludeColumn((String)excludeColumns.get(i));
        }
        return this;
    }

    public BeanQueryFactoryBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public BeanQueryFactoryBuilder columnType(String columnName, int sqlType) {
        this.columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
        return this;
    }

    public BeanQueryFactoryBuilder updateKeyColumn(String columnNames) {
        if (this.updateKeyColumnSet == null) {
            this.updateKeyColumnSet = new LinkedHashSet();
        }
        this.updateKeyColumnSet.add(columnNames.toLowerCase());
        return this;
    }

    private boolean isUpdateKey(String columnName) {
        if (this.updateKeyColumnSet == null) {
            return false;
        }
        return this.updateKeyColumnSet.contains(columnName.toLowerCase());
    }

    public QueryFactory buildUpdate() {
        ColumnProperty[] columnProperties = this.toColumnProperties();
        StringBuffer columnBuffer = new StringBuffer(columnProperties.length * 7);
        ArrayList<ColumnProperty> updateColumnProperties = new ArrayList<ColumnProperty>();
        ArrayList<ColumnProperty> pkColumnProperties = new ArrayList<ColumnProperty>();
        columnBuffer.append("update ").append(this.tableName).append(" set ");
        boolean flg = false;
        for (int i = 0; i < columnProperties.length; ++i) {
            ColumnProperty columnProperty = columnProperties[i];
            if (this.isUpdateKey(columnProperty.getColumnName())) {
                pkColumnProperties.add(columnProperty);
                continue;
            }
            if (flg) {
                columnBuffer.append(',');
            } else {
                flg = true;
            }
            columnBuffer.append(columnProperty.getColumnName()).append("=?");
            updateColumnProperties.add(columnProperty);
        }
        StringBuffer whereBuffer = null;
        if (!pkColumnProperties.isEmpty()) {
            Iterator iterator = pkColumnProperties.iterator();
            while (iterator.hasNext()) {
                if (whereBuffer == null) {
                    whereBuffer = new StringBuffer(" where ");
                } else {
                    whereBuffer.append(" and ");
                }
                ColumnProperty columnProperty = (ColumnProperty)iterator.next();
                whereBuffer.append(columnProperty.getColumnName()).append("=?");
            }
        }
        ArrayList<ColumnProperty> list = new ArrayList<ColumnProperty>(updateColumnProperties);
        list.addAll(pkColumnProperties);
        if (whereBuffer != null) {
            columnBuffer.append(whereBuffer);
        }
        String sql = columnBuffer.toString();
        return new BeanQueryFactory(sql, list.toArray(new ColumnProperty[list.size()]));
    }

    public QueryFactory buildInsert() {
        ColumnProperty[] columnProperties = this.toColumnProperties();
        StringBuffer columnBuffer = new StringBuffer(columnProperties.length * 7);
        StringBuffer valueBuffer = new StringBuffer(columnProperties.length * 2);
        columnBuffer.append("insert into ").append(this.tableName).append("(");
        valueBuffer.append(" values ( ");
        boolean flg = false;
        for (int i = 0; i < columnProperties.length; ++i) {
            if (flg) {
                columnBuffer.append(',');
                valueBuffer.append(',');
            } else {
                flg = true;
            }
            ColumnProperty columnProperty = columnProperties[i];
            columnBuffer.append(columnProperty.getColumnName());
            valueBuffer.append('?');
        }
        columnBuffer.append(" ) ");
        valueBuffer.append(" ) ");
        String sql = columnBuffer.append(valueBuffer).toString();
        return new BeanQueryFactory(sql, columnProperties);
    }

    protected ColumnProperty[] toColumnProperties() {
        PropertyDescriptor[] propertyDescriptors = ReflectionUtil.propertyDescriptors(this.beanClass);
        ArrayList<ColumnProperty> columnProperties = new ArrayList<ColumnProperty>();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            String columnName;
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            Method getter = propertyDescriptor.getReadMethod();
            if (getter == null || propertyDescriptor.getWriteMethod() == null || "class".equals(propertyDescriptor.getName()) || this.excludeColumns.contains((columnName = this.nameMapping.toColumnName(propertyDescriptor)).toLowerCase())) continue;
            Integer sqlType = (Integer)this.columnTypeMap.get(columnName.toLowerCase());
            columnProperties.add(new ColumnProperty(columnName, getter, sqlType == null ? TypeMappings.getValueType(propertyDescriptor.getPropertyType()) : TypeMappings.getValueType(propertyDescriptor.getPropertyType(), sqlType)));
        }
        return columnProperties.toArray(new ColumnProperty[columnProperties.size()]);
    }
}

