program SSTEPP;
{$ASMMODE Intel}
var
  geax, gedx: longint;
  pfid, pvid: byte;
  code: integer;

procedure enabless; assembler;
asm
  mov ecx,$1A0
  DB $0F,$32 {rdmsr}
  or eax,65536
  DB $0F,$30 {wrmsr}
end;

procedure writefidvid(reax, redx: longint); assembler;
asm
  mov eax,dword ptr [reax]
  mov edx,dword ptr [redx]
  mov ecx,$199
  DB $0F,$30 {wrmsr}
end;

procedure readfidvid(var reax: longint; var redx: longint; pending: boolean); assembler;
asm
  mov ecx,$198
  cmp byte ptr [pending],true
  jne @nopending
  mov ecx,$199
@nopending:
  DB $0F,$32 {rdmsr}
  mov edi,[reax]
  mov [edi],eax
  mov edi,[redx]
  mov [edi],edx
end;

function checksupport: boolean; assembler;
asm
  pushfd               {cpuid detect}
  pop eax
  mov ebx,eax
  btc eax,21
  push eax
  mov ecx,[esp]
  popfd
  pushfd
  mov ecx,[esp]
  pop eax
  cmp eax,ebx
  jz @nosupport

  mov eax,1          {speedstep detect}
  DB 0Fh,0A2h        {cpuid}
  test ecx,128
  jz @nosupport
  mov eax,true
  jmp @exit
@nosupport:
  mov eax,false
@exit:
end;

begin
  writeln('Speedstep 1.0 by Falcosoft');
  writeln('usage: sstepp [multiplier] [voltageid] -without parameters shows CPU info');
  writeln;
  if not checksupport then
  begin
    writeln('CPU is not supported!');
    exit;
  end;
  enabless;
  if paramcount <> 2 then
  begin
    readfidvid(geax, gedx, true);
    writeln('LastTriedFid: ', (geax shr 8) and $FF);
    writeln('LastTriedVid: ', geax and $FF);

    readfidvid(geax, gedx, false);
    writeln('CurrentFid: ', (geax shr 8) and $FF);
    writeln('CurrentVid: ', geax and $FF);
    writeln('MaxFid: ', (gedx shr 8) and $FF);
    writeln('MaxVid: ', gedx and $FF);
    writeln('MinFid: ', (gedx shr 24) and $FF);
    writeln('MinVid: ', (gedx shr 16) and $FF);
    writeln;
  end
  else
  begin
    val(paramstr(1), pfid, code);
    val(paramstr(2), pvid, code);

    gedx := 0;
    geax := pvid or (pfid shl 8);
    writefidvid(geax, gedx);

    writeln('New settings applied...');
    readfidvid(geax, gedx, true);
    writeln('LastTriedFid: ', (geax shr 8) and $FF);
    writeln('LastTriedVid: ', geax and $FF);

    readfidvid(geax, gedx, false);
    writeln('CurrentFid: ', (geax shr 8) and $FF);
    writeln('CurrentVid: ', geax and $FF);
  end;

end.

