{$M 8192,0,0}
{
 FreeDOS Password
 Written in FreePascal by Mateusz Viste "Fox" / the.killer@wp.pl

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
}
program FreeDOS_Password;
uses CRT, DOS, FOXCUBS;
const pVer: String[4]='0.50';
var Login, Password, GoodPassword: String[25];
    DATAFile, LOGFile: Text;
    CurDir: String;
    Messages: Array[1..24] of String;

Procedure GetDirectory;
 var
  D: DirStr;
  N: NameStr;
  E: ExtStr;
Begin
 FSplit(ParamStr(0), D, N, E);
 CurDir := D;
end;

procedure LoadMessages;
var x: ShortInt;
    ok: Boolean;
 Begin
    ok := True;
    for x := 1 to 24 do
      Begin
        Messages[x] := LoadMessage(0,x);
        if Messages[x] = '' then ok := False;
      end;
    If ok=False then
      Begin
        Messages[1]:='Users';
        Messages[2]:='You have to define at least one user:';
        Messages[3]:='Login.....:';
        Messages[4]:='Password..:';
        Messages[5]:='User';
        Messages[6]:='has been added';
        Messages[7]:=' WARNING! A stranger has tried to log at the previous login.';
        Messages[8]:='          For more informations, see the log file.';
        Messages[9]:=' Press any key...';
        Messages[10]:='Access denied!';
        Messages[11]:='Enter the login of the user you want remove:';
        Messages[12]:=' User removed.';
        Messages[13]:='not found!';
        Messages[14]:='Enter the user you want to add:';
        Messages[15]:='User added';
        Messages[16]:=' The login';
        Messages[17]:='is already used.';
        Messages[18]:=' Options:';
        Messages[19]:=' /adduser   Add a new user to the program';
        Messages[20]:=' /login     Login';
        Messages[21]:=' /remuser   Remove an user from the program';
        Messages[22]:='has successfuly logged';
        Messages[23]:='has tried to login';
        Messages[24]:='has been removed';
    end;
 End;

procedure WriteReport(Action:String);
 const month: array [1..12] of String[3] = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');
 var Min, H, d2: String[2];
     y, m, d, dow, Hour, Minute, Second, Sec100: Word;
Begin
Append(LOGFile);
GetDate(y,m,d,dow);
GetTime(Hour, Minute, Second, Sec100);
str(Minute,Min);
str(d,d2);
str(Hour,H);
if Minute<10 then Min:='0'+Min;
if Hour<10 then H:='0'+H;
if d<10 then d2:='0'+d2;
Writeln(LOGFile,d2,' ',month[m],' ',y,',',H,':',Min,'; ',Action);
Close(LOGFile);
end;

Procedure Beep;
begin
 sound(400);
 delay(300);
 nosound;
 delay(300);
end;

Function EnterDATA(Character: String):String;
 var Key: Char;
     Second: Word;
     Entry: String[25];
begin
Entry:='';
Second:=0;
repeat
Key:=Readkey;
if Second<26 then Second:=Second+1;
if (Key<>chr(13)) and (Key<>chr(8)) and (Second<26) then Entry:=Entry+Key;
if (Key<>chr(13)) and (Key<>chr(8)) and (Character='') and (Second<26) then write(Key);
if (Key<>chr(13)) and (Key<>chr(8)) and (Character='*') and (Second<26) then write('*');
if (Second=26) and (Ord(Key)<>13) and (Key<>chr(8)) then Beep;
if (Key=chr(8)) then
 begin
  if Length(Entry)>0 then
   begin
    gotoxy(WhereX-1,WhereY);
    write(' ');
    gotoxy(WhereX-1,WhereY);
    delete(Entry,length(Entry),1);
    Second:=Second-2;
   end
  else Beep;
 end;
until Key=chr(13);
writeln;
EnterDATA:=Entry
end;

Function CheckSum(instr:string):longint;
Var  Result: LongInt;
     I : LongInt;
Begin
 Result := 0;
 For I := 1 to Length(instr) do
  Begin
   Result := Ord(instr[i]) + (Result Shl 6) + (Result Shl 16) - Result;
  End;
 CheckSum := (Result And $7FFFFFFF);
end;

Procedure ListUsers;
  var dow: word;
      line: string[25];
Begin
reset(DATAFile);
clrscr;
writeln;
write(Messages[1],': [');
dow:=0;
repeat
Readln(DATAFile,line);
if line[1]=#0 then
 Begin
 if dow=1 then write(',');
 dow:=1;
 write(line);
 end;
until eof(DATAFile);
Reset(DATAFile);
Writeln(' ]');
end;

Procedure Register;
Begin
rewrite(DATAFile);
close(DATAFile);
ClrScr;
writeln;
writeln(Messages[2]);
writeln;
write(Messages[3],' ');
login:=EnterDATA('');
write(Messages[4],' ');
password:=EnterDATA('');
Append(DATAFile);
writeln(DATAFile,#0+Login);
writeln(DATAFile,CheckSum(password));
WriteReport(Messages[5]+' '+Login+' '+Messages[6]);
Close(DATAFile);
ClrScr;
Halt(0);
end;

Procedure CheckDATAFile;
var FSize: Shortint;
    Znak: Char;
 Begin
  Reset(DATAFile);
  FSize := 0;
  Repeat Inc(FSize); Read(DATAFile,znak); until EOF(DATAFile) or (FSize=5);
  Close(DATAFile);
  if FSize < 4 then Register;
 end;

Procedure ResLog;
Begin
rewrite(LOGFile);
writeln(LOGFile,'The log file of FreeDOS Password v',pVer,'  Author: Mateusz Viste "Fox"');
writeln(LOGFile,'---------------------------------------------------------------------------');
Close(LOGFile);
end;

Procedure LogUser;
 var line,Password2: string[25];
     WarningFile, LastLogin: text;
 label Start,BadEntry,Ok;
Begin
Assign(WarningFile, CurDir+'WARNING.LOG');
Start:

ListUsers;

Writeln;
write(Messages[3]+' ');
Login:=EnterDATA('');
write(Messages[4]+' ');
Password:=EnterDATA('*');
Repeat
Readln(DATAFile,line);
if eof(DATAFile) then goto BadEntry;
until line=#0+Login;
Readln(DATAFile,GoodPassword);
Password2 := Password;
STR(CheckSum(Password),Password2);
Close(DATAFile);
if Password2=GoodPassword then
begin
ClrScr;
Assign(LastLogin, CurDir+'LASTUSER.BAT');
rewrite(LastLogin);
writeln(LastLogin,'@SET USER='+Login);
close(LastLogin);
WriteReport(Login+' '+Messages[22]);

if FSearch('WARNING.LOG',CurDir) <> '' then
Begin
 ClrScr;
 WriteLn(Messages[7]);
 WriteLn(Messages[8]);
 WriteLn;
 WriteLn(Messages[9]);
 Erase(WarningFile);
 Beep;
 ReadKey;
 ClrScr;
 end;
goto Ok;
end;
goto BadEntry;

BadEntry:
WriteReport(Login+' ['+password+'] '+Messages[23]);
ReWrite(WarningFile);
Close(WarningFile);
writeln;
writeln(Messages[10]);
Beep;
delay(400);
Goto Start;
Ok:
Halt(0);
End;

Procedure RemUser;
var JobDone: boolean;
    Login2, line: String[25];
    DATAFile2: text;
begin
ClrScr;
ListUsers;
writeln;
writeln(Messages[11]);
write('> ');
login2:=EnterDATA('');
Reset(DATAFile);
Assign(DATAFile2, CurDir+'PASSWORD.DA~');
Rewrite(DATAFile2);
JobDone:=False;
 Repeat
 Readln(DATAFile,line);
  if line=#0+Login2 then
   Begin;
   Readln(DATAFile,line);
   Readln(DATAFile,line);
   JobDone:=True;
  end;
 if line<>'' then Writeln(DATAFile2,line);
 until eof(DATAFile);
Close(DATAFile);
Close(DATAFile2);
Rewrite(DATAFile);
Reset(DATAFile2);
 Repeat
  Readln(DATAFile2,line);
  Writeln(DATAFile,line);
 until eof(DATAFile2);
Close(DATAFile);
Close(DATAFile2);
ClrScr;
if JobDone=True then
 Begin
  WriteReport(Messages[5]+' '+Login2+' '+Messages[24]);
  Writeln(Messages[12]);
  end
 Else
  Begin
  Writeln(Messages[5],' ',Login2,' ',Messages[13]);
 end;
Writeln;
Erase(DATAFile2);
Halt(0);
end;

Procedure AddUser;
var Login2,Password2,line: string[25];
label DoubleLogin;
begin
ClrScr;
ListUsers;
writeln;
writeln(Messages[14]);
writeln;
write(Messages[3],' ');
login2:=EnterDATA('');
Reset(DATAFile);
 Repeat
  Readln(DATAFile,line);
  if line=#0+Login2 then goto DoubleLogin;
 until eof(DATAFile);
Close(DATAFile);
write(Messages[4],' ');
Password2:=EnterDATA('');
Append(DATAFile);
writeln(DATAFile,#0+login2);
writeln(DATAFile,CheckSum(password2));
WriteReport(Messages[5]+' '+Login2+' '+Messages[6]);
Close(DATAFile);
ClrScr;
writeln(Messages[15]);
Halt(0);
DoubleLogin:
ClrScr;
Writeln;
Writeln(Messages[16],' "',login2,'" ',Messages[17]);
Writeln;
Halt(0);
end;

Procedure NoParam;
Begin
 writeln;
 writeln(' FreeDOS Password v',pVer,' by Mateusz Viste "Fox" / the.killer@wp.pl [May 2005]');
 writeln;
 writeln('                          http://the.killer.webpark.pl');
 writeln;
 writeln('       - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -');
 writeln('        This program is free software;  you can redistribute  it and/or');
 writeln('        modify it  under the  terms of  the GNU General Public  License');
 writeln('        as published by the Free Software Foundation;  either version 2');
 writeln('        of the License, or (at your option) any later version.         ');
 writeln;
 writeln('        This program is distributed in the hope that it will be useful,');
 writeln('        but WITHOUT ANY WARRANTY;  without even the implied warranty of');
 writeln('        MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the');
 writeln('        GNU General Public License for more details.                   ');
 writeln('       - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -');
 writeln;
 writeln(Messages[18]);
 writeln(Messages[19]);
 writeln(Messages[20]);
 writeln(Messages[21]);
 writeln;
 Halt(0);
end;


Begin    {  The program begins just here  }
CheckBreak:=False;
GetDirectory;
LoadMessages;
Assign(DATAFile, CurDir+'PASSWORD.DAT');
Assign(LOGFile, CurDir+'PASSWORD.LOG');
if FSearch('PASSWORD.LOG',CurDir) = '' then ResLog;
if FSearch('PASSWORD.DAT',CurDir) = '' then Register;
CheckDATAFile;
if (ParamCount = 0) or (ParamCount>1) then NoParam;
if paramstr(1)='/login' then LogUser;
if paramstr(1)='/adduser' then AddUser;
if paramstr(1)='/remuser' then RemUser;
NoParam;

end.