/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------

#include <string.h>
#include <stdlib.h>
#include <pc.h>

#include "AWorm.h"
#include "DblBuf.h"
#include "Vga256.h"

//---------------------------------------------------------------------------
Worm::Worm() {}
//---------------------------------------------------------------------------
Worm::~Worm() {}
//---------------------------------------------------------------------------
void Worm::Init(LevelHeader *lev,DblBuf *buf) {

 BodyParts=lev->CurrSize;

 currDir=DIR_RIGHT;
 pivotOFF=true;
 EventNotify=true;

 num_of_pvs=0;
 start_from_pvs=0;
 growCnt=0;

 ptrHead=new Head;
 ptrHead->type=IS_A_HEAD;

 ptrHead->Make(BodyParts-1,BodyParts-1);


  DBuffer=buf;
  ptrHead->Init(lev,"art/Head.spr",buf);

}
//---------------------------------------------------------------------------
void Worm::Display() {

 ptrHead->Display();

}
//---------------------------------------------------------------------------
void Worm::Crawl(LevelHeader *lev,int &t) {

 bool test;

 if(EventNotify)
  Event=ptrHead->OnEvent(lev);

    switch(Event) {

     case NOTHING_TO_DO:ptrHead->Crawl(&pivots[0],
                                       num_of_pvs,StopCrawling,test);
                        break;

     case WORM_EAT:     BodyParts++;
                        lev->CurrSize=BodyParts;
                        lev->LevelProgr++;
                        ptrHead->Grow(BodyParts-1);
                        EventNotify=true;
                        t=0;
                        break;

     case WORM_DEATH:   ptrHead->Die(t);
                        EventNotify=false;
                        lev->WormDeath=false;

                         if(t<200) t++;

                          else {
                            t=0;
                            EventNotify=true;
                            lev->NumLives--;
                            lev->WormDeath=true;
                          }

                        break;

   }


 if(test) {

  start_from_pvs++;
  num_of_pvs--;

 }

}
//---------------------------------------------------------------------------
void Worm::AddPivot(char dir) {

 pivots[num_of_pvs].dir=dir;
 pivots[num_of_pvs].x=ptrHead->x;
 pivots[num_of_pvs].y=ptrHead->y;

 num_of_pvs++;

}
//---------------------------------------------------------------------------












