/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#ifndef _SPRITE_H_
#define _SPRITE_H_

#include "DblBuf.h"

#define ROTATE_90DEG_LEFT   0
#define ROTATE_90DEG_RIGHT  1
#define ROTATE_180DEG_LEFT  2
#define ROTATE_180DEG_RIGHT 3
//---------------------------------------------------------------------------
class Sprite {

   public:

    Sprite();
    ~Sprite();

    unsigned char *PtrSprite;
    int W,H,x,y,Size;

    void LoadFrom_SPR_File(char *filename);
    void LoadFrom_RAW_File(char *filename);

    void SaveToFile(char *filename);

    void ReadSpriteFromBuf(DblBuf *buf,int width,int height);

    void ReadSpriteFromBuf_2(DblBuf *buf,int x,int y,
                             int width,int height);

    void DrawSprite(int x,int y,unsigned char *dblbuf);
    void Transform(char type,Sprite *outSprite);


};
//---------------------------------------------------------------------------
class Frames {

 public:

  Frames();
  ~Frames();

  Sprite *FrameData;
  int cycleCnt;

  void Anim(int x,int y,unsigned char *buf);

};
//---------------------------------------------------------------------------
#endif;
