/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>

#include "Font.h"
//---------------------------------------------------------------------------
FontBMP::FontBMP() {};
//---------------------------------------------------------------------------
FontBMP::~FontBMP() {};
//---------------------------------------------------------------------------
void CharBMP::ReadChr(int x,int y,int width,int height,
                      unsigned char *buf,int id) {



 int i,startOff,incx=-1,incy=0;
 int precalc=0;

   ID=id;
   W=width;
   H=height;
   Size=W*H;

    if(PtrSprite!=NULL) delete PtrSprite;

   PtrSprite=(unsigned char *) malloc(Size);

   startOff=x+y*320;

  for(i=0;i<Size;i++) {

    if(incx<(W-1)) incx++;

     else {
       incx=0;
       incy++;
       precalc=incy*320;
     }

      PtrSprite[i]=buf[startOff+(incx+precalc)];

  }

}
//---------------------------------------------------------------------------
void CharBMP::DrawChr(int x, int y,unsigned char color,unsigned char *dblbuf)
{

 int i,startOff,incx=-1,incy=0;
 int precalc=0;
 unsigned char testCol;

 col=color;

   startOff=x+y*320;

  for(i=0;i<Size;i++) {

    if(incx<(W-1)) incx++;

     else {
       incx=0;
       incy++;
       precalc=incy*320;
     }

     testCol=PtrSprite[i];

      if((testCol!=0)&&((x+incx)<320)&&((y+incy)<200))
        dblbuf[startOff+(incx+precalc)]=col;

  }

  //dblbuf->Rect(x,y,W,H);

}
//---------------------------------------------------------------------------
void FontBMP::Init(int n) {

 int i;

 num=n;
 CharsData=new CharBMP[n];

 Cursor.x=0;Cursor.y=0;
 Cursor.col=255;
 Cursor.cfactor=1;
 Cursor.carriage=12;

  for(i=0;i<n;i++) CharsData[i].Size=0;


}
//---------------------------------------------------------------------------
void FontBMP::GrabFont(int x0, int y0,int dx,int dy,
                       unsigned char i1,unsigned char i2,
                       unsigned char *buf) {

 int id,cnt=0;

 for(id=i1;id<i2;id++) {

  CharsData[id].ReadChr(x0+(cnt*dx+0),y0,dx,dy,buf,id);
  cnt++;

 }

}
//---------------------------------------------------------------------------
void FontBMP::SaveToFile(char *filename) {

 FILE *fntfile;
 int i;

  fntfile=fopen("test.fnt","wb");
  fwrite(&num,sizeof(num),1,fntfile);

   for(i=0;i<255;i++) {

     if(CharsData[i].Size!=0) {

      CharsData[i].ID=i;
      fwrite(&CharsData[i],sizeof(CharBMP),1,fntfile);
      fwrite(CharsData[i].PtrSprite,CharsData[i].Size,1,fntfile);

   }
  }

  fclose(fntfile);

}
//---------------------------------------------------------------------------
void FontBMP::LoadFromFile(char *filename) {

 FILE *fntfile;
 int i,n_chars,cnt=0;
 CharBMP *chData;

 chData=new CharBMP;

  fntfile=fopen(filename,"rb");
  fread(&n_chars,sizeof(n_chars),1,fntfile);

   while(!feof(fntfile)) {

      fread(chData,sizeof(CharBMP),1,fntfile);

      CharsData[chData->ID].ID=chData->ID;

      CharsData[chData->ID].W=chData->W;
      CharsData[chData->ID].H=chData->H;
      CharsData[chData->ID].Size=chData->Size;

      CharsData[chData->ID].PtrSprite=(unsigned char *)malloc(chData->Size);

      fread(CharsData[chData->ID].PtrSprite,chData->Size,1,fntfile);

      cnt++;


   }

  fclose(fntfile);

  num=cnt;

}
//---------------------------------------------------------------------------
void FontBMP::GotoXY(int x,int y) {Cursor.x=x;Cursor.y=y;}

int FontBMP::Print(const char *string,unsigned char *buf) {

  int size,i,inc=0;
  int cfac=Cursor.cfactor;

 size=strlen(string);

  for(i=0;i<size;i++) {

     if(string[i]!='\n') {

      if((i-1)>=0) inc+=CharsData[string[i-1]].W-cfac;
       CharsData[string[i]].DrawChr(Cursor.x+(inc),Cursor.y,Cursor.col,buf);

     }

     else {

      Cursor.y+=10;
     // return 0;

     }

  }

}
//---------------------------------------------------------------------------
void FontBMP::ChangeCol(unsigned char col) {Cursor.col=col;}
//---------------------------------------------------------------------------
void FontBMP::Carriage(int carr) {Cursor.carriage=carr;}
//---------------------------------------------------------------------------




