
with splaylist;
with text_io;

with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

with ada.command_line;
with ada.calendar;


package emutils is


use Ada.Strings.Unbounded;
use Ada.Strings.Unbounded.Text_IO;


	package myint_io is new text_io.integer_io(integer);

	package myfloat_io is new text_io.float_io(float);

	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");




	failure: boolean := false;
	tsec0, tsec1 : ada.calendar.day_duration;






--------------- begin types for hashtable --------------------------

	--type ubyte is range 0..255; --(1-byte)
	--type ushort is range 0..2**32-1; -- (4-bytes)
	-- note that 8-byte integers may not be defined in above fashion.

	-- Be careful with these modular types because subtraction
	-- and division do not function normally.  The usage here 
	-- only requires addition & multiplication.  Only
	-- ulong MUST be defined this way.  The others are
	-- defined similarly due only to aesthetics.
	type ubyte is mod 2**8;   --(1-byte)  0..255
	type ushort is mod 2**16; --(2-bytes) 0..65535
	type ulong is mod 2**64;  --(8-bytes)

	usmx : constant ushort := 65535;
	ubmx : constant ubyte := 255;

	maxrows : constant ushort := 20;
	maxcols : constant ushort := 25;
	maxsize : constant ushort := maxrows*maxcols;


	subtype interange is ushort range 1..maxsize;

	type booltype is array(interange) of boolean;
	type vfstype is array(ubyte) of ubyte;
	type vftype is array(interange) of ubyte;
	type vstype is array(interange) of ushort;


	type keytype is 
	record
		suma, sumb,sumc : ulong;
		pulkey     : ubyte;
	end record;

	type hashrectype is
	record
		ngoals,
		prsave, pcsave, prevmove, boxpull : ubyte;
		totmovz,totpulz: ushort;
		vfsave : vfstype;
		prevkey : keytype;
	end record;



	function "<" (k1, k2: in keytype ) return boolean;
	function ">" (k1, k2: in keytype ) return boolean;

	package mysplay is new splaylist( keytype, hashrectype, "<", ">" );
	use mysplay;


	mytree : mysplay.listtype;
	status : mysplay.statustype; -- Ok, found, ...


	win_suma, win_sumb, win_sumc : ulong := 0;
	bwin_pulkey, pwin_pulkey : ubyte := 0;
	bwin_key, pwin_key : keytype;

	olmovz,olpulz,
	minMoves, minBoxPulls: ushort := usmx;

	careful,
	relent, urgent, desperate, dying, winner : boolean := false;

	pfff,hfff,
	ff, ovf, vf, nappch : vftype;

	bvalid,pvalid,
	xtunn, nexus, enexus : booltype := (others=>false);

	bestnk, bestnkp : ushort := 0;
	nk, ng: ushort;
	gpr, gpc : ushort := usmx; --0;


	ee : vstype := (others=>usmx);
	-- ee in 0..255 for feasible box positions...
	-- ee=ubmx elsewhere.  This array is defined
	-- within readpuzzle.





	savefp, gngoals : ushort := 0;

	ncols, nrows : ushort;

	pfmax : ushort := 0;

	grow,gcol,
	prfinal, pcfinal : array(interange) of ushort;
	pr, pc : ushort;

	maxbx : constant ushort := 24;
	type etype is array(1..maxbx) of ubyte;


	depth: integer := 0;
	level, maxlevel : integer;

	infilname : unbounded_string;




procedure bitrep(
	nb : ushort; -- 1..24
	e  : etype; -- 1..255
	suma, sumb, sumc : in out ulong );

function indx(r,c : ushort) return ushort;







function psetwinkey( wpkey: ubyte ) return keytype;


function ptestleft return boolean;
function ptestright return boolean;
function ptestdown return boolean;
function ptestup return boolean;

function bwallleft return boolean;
function bwallright return boolean;
function bwalldown return boolean;
function bwallup return boolean;

function wallleft return boolean;
function wallright return boolean;
function walldown return boolean;
function wallup return boolean;




function ignore_this_line( line : string; len:natural ) return boolean;

procedure readPuzzle( fnam: unbounded_string; lvl1: integer );



procedure prestore( rec : hashrectype );

procedure pdocument(
	solutionPath: in out unbounded_string;
	key : keytype;
	nmoves, bmoves : in out integer);

function trimmed_int( i: integer ) return unbounded_string;
procedure pwinnertest( 
	key: keytype; 
	solutionPath: in out unbounded_string;
	tpulz, tmovz: ushort
	);

function min(a,b: ushort) return ushort;


procedure psaveifnew( 
	solutionPath: in out unbounded_string;
	okey: keytype; pmove, boxpulls, moves : ushort );
procedure psave0;

procedure pcountbest( k,g : in out ushort );

procedure pdump;

------------- ibox below this line -------------------------

	-- structs for Dynamic Programming relaxation [flood-fill]
	fff, bestpred, bestcost : vftype;

	hbestcost,pbestcost: vstype;

	htunl,vtunl : booltype := (others=>false);
	corral,
		hviano,hviaso,hviaea,hviawe,
		pviano,pviaso,pviaea,pviawe,
		viano, viaso, viaea, viawe,
		cviano, cviaso, cviaea, cviawe : booltype;

	usinf  : constant ushort := 9999;
	ubinf  : constant ubyte := ubmx-1; 
	--254 (ubinf+1 must be a valid ubyte)

	fromno: constant ubyte := 0;
	fromso: constant ubyte := 1;
	fromea: constant ubyte := 2;
	fromwe: constant ubyte := 3;
	none  : constant ubyte := ubinf; --254





procedure bsaveifnew(
	solutionPath: in out unbounded_string;
	okey: keytype; 
	pmove, boxpulls : ushort;
	pr,pc, br,bc: ushort
	);

procedure bsave0;

procedure bwinnertest( 
	key: keytype; 
	solutionPath: in out unbounded_string;
	tpulz: ushort
	);



function bsetwinkey( wpkey: ubyte ) return keytype;




procedure brestore( rec : hashrectype;  pr,pc : out ushort );
procedure bdump;

procedure bdocument(
	solutionPath: in out unbounded_string;
	key : keytype;
	nmoves, bmoves : in out ushort;
	firstcall: boolean
	);


function btestleft(br,bc:ushort) return boolean;
function btestright(br,bc:ushort) return boolean;
function btestdown(br,bc:ushort) return boolean;
function btestup(br,bc:ushort) return boolean;



ppath : array(1..ubmx) of character;

function dppathexists( r1,c1 : ushort ) return boolean;
procedure dppath( r1,c1 : ushort;  np: out ubyte );

procedure initwdpcorral;
procedure initdpcorral;
procedure dpcorral(
	r0,c0 : ushort; --puller.pos
	ulkey : out ubyte -- 3rd component of keytype
	);
procedure dpwcorral(
	r0,c0 : ushort; --puller.pos
	ulkey : out ubyte -- 3rd component of keytype
	);
procedure dppathprep(
	r0,c0 : ushort --puller.pos
	);
procedure initdp;


procedure dppuller;
procedure dpbox;
procedure dumpvalid;


end emutils; --package

