/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;

public class MDSMethod {
    private Matrix target;
    private Matrix coordinate;
    private Matrix eigenValues;
    private Matrix eigenVectors;
    private int[] indexes;

    public MDSMethod(Matrix matrix) {
        this.target = matrix;
    }

    protected Matrix getCenteredInnerProductMatrix() {
        Matrix centering = MDSMethod.getCenteringMatrix(this.target.getColumnDimension());
        Matrix trans = centering.transpose();
        return centering.times(this.target).times(trans).times(-1.0);
    }

    public Matrix getEigenValues() {
        if (this.eigenValues == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenValues.clone();
    }

    public Matrix getEigenVectors() {
        if (this.eigenVectors == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenVectors.clone();
    }

    public double[] getCoordinate(int axis) {
        if (this.coordinate == null) {
            this.getCoordinateMatrix();
        }
        double[] v = new double[this.coordinate.getRowDimension()];
        int i = 0;
        while (i < v.length) {
            v[i] = this.coordinate.get(i, this.indexes[axis]);
            ++i;
        }
        return v;
    }

    public Matrix getCoordinateMatrix() {
        if (this.coordinate == null) {
            Matrix mat = this.getCenteredInnerProductMatrix();
            EigenvalueDecomposition eigen = mat.eig();
            Matrix eigenVectors = eigen.getV();
            Matrix eigenValues = eigen.getD();
            Matrix coordinate = (Matrix)eigenVectors.clone();
            int col = mat.getColumnDimension();
            int row = mat.getRowDimension();
            int i = 0;
            while (i < row) {
                int j = 0;
                while (j < col) {
                    double v = coordinate.get(i, j);
                    coordinate.set(i, j, v *= Math.sqrt(eigenValues.get(j, j)));
                    ++j;
                }
                ++i;
            }
            this.sortValues(eigenValues);
            this.coordinate = coordinate;
            this.eigenVectors = eigenVectors;
            this.eigenValues = eigenValues;
        }
        return this.coordinate;
    }

    protected static Matrix getCenteringMatrix(int n) {
        Matrix matrix = Matrix.identity((int)n, (int)n);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                matrix.set(i, j, matrix.get(i, j) - 1.0 / (double)n);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    private void sortValues(Matrix m) {
        double[] v = new double[m.getColumnDimension()];
        int[] index = new int[v.length];
        int i = 0;
        while (i < v.length) {
            v[i] = m.get(i, i);
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < v.length) {
            int j = i + 1;
            while (j < v.length) {
                if (Math.abs(v[i]) < Math.abs(v[j])) {
                    double tmpValue = v[j];
                    v[j] = v[i];
                    v[i] = tmpValue;
                    int tmpIndex = index[j];
                    index[j] = index[i];
                    index[i] = tmpIndex;
                }
                ++j;
            }
            ++i;
        }
        this.indexes = index;
    }
}

