/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.birthmarks.BirthmarkService;
import jp.naist.se.stigmata.spi.BirthmarkComparatorSpi;
import jp.naist.se.stigmata.spi.BirthmarkExtractorSpi;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.spi.ServiceProvider;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListCellRenderer;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class BirthmarkDefinitionPane
extends JPanel {
    private static final long serialVersionUID = 3932637653297802978L;
    private StigmataFrame stigmata;
    private DefaultListModel model;
    private InformationPane information;
    private JList serviceList;
    private JButton newService;
    private JButton removeService;
    private List<BirthmarkSpi> addedService = new ArrayList<BirthmarkSpi>();
    private List<BirthmarkServiceListener> listeners = new ArrayList<BirthmarkServiceListener>();

    public BirthmarkDefinitionPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
        this.updateView();
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        for (BirthmarkSpi service : this.addedService) {
            this.model.removeElement(service);
        }
    }

    public void updateEnvironment(BirthmarkEnvironment environment) {
        for (BirthmarkSpi service : this.addedService) {
            if (environment.getService(service.getType()) != null) continue;
            if (service instanceof BirthmarkService) {
                ((BirthmarkService)service).setBirthmarkEnvironment(environment);
            }
            environment.addService(service);
        }
    }

    private void initData() {
        this.information.initData();
        this.model.addElement(Messages.getString("newservice.definition.label"));
        BirthmarkSpi[] birthmarkSpiArray = this.stigmata.getEnvironment().findServices();
        int n = birthmarkSpiArray.length;
        int n2 = 0;
        while (n2 < n) {
            BirthmarkSpi service = birthmarkSpiArray[n2];
            this.model.addElement(service);
            ++n2;
        }
    }

    private void initLayouts() {
        JPanel panel = new JPanel(new BorderLayout());
        this.model = new DefaultListModel();
        this.serviceList = new JList(this.model);
        this.serviceList.setCellRenderer(new BirthmarkServiceListCellRenderer(new Dimension(250, 20), 60));
        JScrollPane scroll = new JScrollPane(this.serviceList);
        scroll.setBorder(new TitledBorder(Messages.getString("servicelist.border")));
        this.serviceList.setToolTipText(Messages.getString("servicelist.tooltip"));
        panel.add((Component)scroll, "West");
        this.information = new InformationPane(this.stigmata, this);
        panel.add((Component)this.information, "Center");
        Box buttonPanel = Box.createHorizontalBox();
        this.newService = Utility.createButton("newservice");
        this.removeService = Utility.createButton("removeservice");
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.newService);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.removeService);
        buttonPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.add((Component)buttonPanel, "South");
        this.removeService.setEnabled(false);
        this.serviceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BirthmarkDefinitionPane.this.listValueChanged(e);
            }
        });
        this.newService.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BirthmarkDefinitionPane.this.addNewService();
            }
        });
        this.removeService.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BirthmarkDefinitionPane.this.removeService();
            }
        });
    }

    private void removeService() {
        BirthmarkSpi service;
        int index = this.serviceList.getSelectedIndex();
        if (index > 0 && (service = (BirthmarkSpi)this.model.getElementAt(index)) != null && service.isUserDefined()) {
            this.model.remove(index);
            for (BirthmarkServiceListener listener : this.listeners) {
                listener.serviceRemoved(service);
            }
        }
        this.stigmata.setNeedToSaveSettings(true);
        this.updateView();
    }

    private void addNewService() {
        BirthmarkService service = this.information.createService();
        this.model.addElement(service);
        this.addedService.add(service);
        for (BirthmarkServiceListener listener : this.listeners) {
            listener.serviceAdded(service);
        }
        this.stigmata.setNeedToSaveSettings(true);
        this.updateView();
    }

    private void listValueChanged(ListSelectionEvent e) {
        int index = this.serviceList.getSelectedIndex();
        if (index > 0) {
            BirthmarkSpi service = (BirthmarkSpi)this.model.getElementAt(index);
            if (service != null) {
                this.information.setService(service);
            }
        } else if (index == 0) {
            this.information.clear();
        }
        this.updateView();
    }

    private void updateView() {
        int index = this.serviceList.getSelectedIndex();
        ListModel model = this.serviceList.getModel();
        BirthmarkSpi service = null;
        if (index > 0) {
            service = (BirthmarkSpi)model.getElementAt(index);
        }
        this.newService.setEnabled((index <= 0 || service.isUserDefined()) && this.information.isAvailableService() && this.isAvailableServiceName(this.information.getType()));
        this.removeService.setEnabled(index > 0 && service.isUserDefined());
        this.information.setEnabled(index <= 0 || service.isUserDefined());
    }

    private boolean isAvailableServiceName(String name) {
        for (BirthmarkSpi service : this.addedService) {
            if (!service.getType().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static class InformationPane
    extends JPanel {
        private static final long serialVersionUID = 37906542932362L;
        private StigmataFrame stigmata;
        private BirthmarkDefinitionPane thisPane;
        private JTextField type;
        private JTextField displayType;
        private JTextArea description;
        private JComboBox extractor;
        private JComboBox comparator;
        private JCheckBox expert;
        private JCheckBox userDefined;

        public InformationPane(StigmataFrame stigmata, BirthmarkDefinitionPane thisPane) {
            this.stigmata = stigmata;
            this.thisPane = thisPane;
            this.initLayouts();
        }

        public String getType() {
            return this.type.getText();
        }

        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.type.setEnabled(flag);
            this.displayType.setEnabled(flag);
            this.description.setEnabled(flag);
            this.extractor.setEnabled(flag);
            this.comparator.setEnabled(flag);
        }

        public BirthmarkService createService() {
            BirthmarkService service = new BirthmarkService();
            service.setType(this.type.getText());
            service.setDisplayType(this.displayType.getText());
            service.setDescription(this.description.getText());
            service.setExtractorClassName(this.extractor.getSelectedItem().toString());
            service.setComparatorClassName(this.comparator.getSelectedItem().toString());
            service.setUserDefined(true);
            return service;
        }

        public void clear() {
            this.type.setText("");
            this.displayType.setText("");
            this.description.setText("");
            this.extractor.getModel().setSelectedItem(null);
            this.comparator.getModel().setSelectedItem(null);
            this.userDefined.setSelected(true);
            this.expert.setSelected(true);
        }

        public boolean isAvailableService() {
            String newType = this.type.getText();
            Object selectedExtractor = this.extractor.getSelectedItem();
            String extractorClass = "";
            if (selectedExtractor != null) {
                extractorClass = selectedExtractor.toString();
            }
            Object selectedComparator = this.comparator.getSelectedItem();
            String comparatorClass = "";
            if (selectedComparator != null) {
                comparatorClass = selectedComparator.toString();
            }
            BirthmarkEnvironment environment = this.stigmata.getEnvironment();
            boolean flag = newType.length() > 0 && this.displayType.getText().length() > 0 && extractorClass.length() > 0 && comparatorClass.length() > 0;
            flag = flag && environment.getService(newType) == null;
            try {
                flag = flag && environment.getClasspathContext().find(extractorClass) != null && environment.getClasspathContext().find(comparatorClass) != null;
            }
            catch (ClassNotFoundException e) {
                flag = false;
            }
            return flag;
        }

        public void setService(BirthmarkSpi service) {
            this.type.setText(service.getType());
            this.displayType.setText(service.getDisplayType());
            this.description.setText(service.getDefaultDescription());
            this.selectComboBoxItem(this.extractor, service.getExtractorClassName());
            this.selectComboBoxItem(this.comparator, service.getComparatorClassName());
            this.userDefined.setSelected(service.isUserDefined());
            this.expert.setSelected(service.isExpert());
            this.setEnabled(service.isUserDefined());
        }

        public void initData() {
            ServiceProvider service;
            this.comparator.addItem("");
            Iterator<ServiceProvider> i = this.stigmata.getEnvironment().lookupProviders(BirthmarkComparatorSpi.class);
            while (i.hasNext()) {
                service = i.next();
                this.comparator.addItem(service.getComparatorClassName());
            }
            this.extractor.addItem("");
            i = this.stigmata.getEnvironment().lookupProviders(BirthmarkExtractorSpi.class);
            while (i.hasNext()) {
                service = (BirthmarkExtractorSpi)i.next();
                this.extractor.addItem(service.getExtractorClassName());
            }
        }

        private void selectComboBoxItem(JComboBox box, String item) {
            box.getModel().setSelectedItem(item);
        }

        private void initLayouts() {
            this.type = new JTextField();
            this.displayType = new JTextField();
            this.extractor = new JComboBox();
            this.comparator = new JComboBox();
            this.expert = new JCheckBox(Messages.getString("define.expert.label"));
            this.userDefined = new JCheckBox(Messages.getString("define.userdef.label"));
            this.description = new JTextArea();
            JScrollPane scroll = new JScrollPane(this.description);
            this.type.setColumns(10);
            this.displayType.setColumns(20);
            this.description.setColumns(40);
            this.description.setRows(10);
            Box box1 = Box.createHorizontalBox();
            box1.add(this.type);
            box1.add(this.displayType);
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalGlue());
            box2.add(this.expert);
            box2.add(Box.createHorizontalGlue());
            box2.add(this.userDefined);
            box2.add(Box.createHorizontalGlue());
            JPanel panel = new JPanel(new GridLayout(3, 1));
            panel.add(box1);
            panel.add(this.extractor);
            panel.add(this.comparator);
            this.setLayout(new BoxLayout(this, 1));
            this.add(panel);
            this.add(box2);
            this.add(scroll);
            this.add(Box.createVerticalGlue());
            Utility.decorateJComponent(this.type, "define.type");
            Utility.decorateJComponent(this.displayType, "define.displaytype");
            Utility.decorateJComponent(scroll, "define.description");
            Utility.decorateJComponent(this.extractor, "define.extractor");
            Utility.decorateJComponent(this.comparator, "define.comparator");
            Utility.decorateJComponent(this.expert, "define.expert");
            Utility.decorateJComponent(this.userDefined, "define.userdef");
            this.userDefined.setEnabled(false);
            this.expert.setEnabled(false);
            this.userDefined.setSelected(true);
            this.expert.setSelected(true);
            this.extractor.setEditable(true);
            this.comparator.setEditable(true);
            DocumentListener listener = new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }

                public void removeUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }

                public void changedUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.type.getDocument().addDocumentListener(listener);
            this.displayType.getDocument().addDocumentListener(listener);
            this.description.getDocument().addDocumentListener(listener);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.comparator.addItemListener(itemListener);
            this.extractor.addItemListener(itemListener);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.comparator.getEditor().addActionListener(actionListener);
            this.extractor.getEditor().addActionListener(actionListener);
        }
    }
}

