/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ComparisonMethod;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.printer.xml.ExtractionResultSetXmlPrinter;
import jp.naist.se.stigmata.result.AbstractExtractionResultSet;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileExtractionResultSet
extends AbstractExtractionResultSet {
    private List<URL> addList = new ArrayList<URL>();
    private boolean addmode = true;
    private int size;
    private ExtractionResultSetXmlPrinter formatter;
    private File targetFile;
    private PrintWriter out;

    public XmlFileExtractionResultSet(BirthmarkContext context, boolean tableType) {
        super(context, tableType);
        this.createTargetFile();
    }

    public XmlFileExtractionResultSet(BirthmarkContext context) {
        super(context);
        this.createTargetFile();
    }

    public XmlFileExtractionResultSet(File file) {
        super(Stigmata.getInstance().createContext());
        this.addmode = false;
        this.addList = null;
        this.size = -1;
        this.targetFile = file;
        this.getContext().setStoreTarget(BirthmarkStoreTarget.XMLFILE);
        this.getContext().setComparisonMethod(ComparisonMethod.ROUND_ROBIN_SAME_PAIR);
    }

    @Override
    public BirthmarkStoreTarget getStoreTarget() {
        return BirthmarkStoreTarget.XMLFILE;
    }

    @Override
    public void addBirthmarkSet(ExtractionTarget target, BirthmarkSet set) throws BirthmarkStoreException {
        if (this.addmode) {
            if (this.formatter == null) {
                try {
                    this.out = new PrintWriter(new FileWriter(this.targetFile));
                    this.formatter = new ExtractionResultSetXmlPrinter();
                    this.formatter.printHeader(this.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out == null || this.formatter == null) {
                throw new BirthmarkStoreException("destination is closed on some reason");
            }
            ++this.size;
        } else {
            throw new BirthmarkStoreException("destination is already closed.");
        }
        this.addList.add(set.getLocation());
        this.formatter.printBirthmarkSet(this.out, set);
    }

    @Override
    public Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget target) {
        this.checkMode();
        return new BirthmarkSetStAXIterator(this.targetFile, this.addList, this.getContext());
    }

    @Override
    public int getBirthmarkSetSize(ExtractionTarget target) {
        return this.size;
    }

    @Override
    public void removeAllBirthmarkSets(ExtractionTarget target) {
        this.targetFile.delete();
        this.size = 0;
        this.addList.clear();
    }

    @Override
    public void removeBirthmarkSet(ExtractionTarget target, BirthmarkSet set) {
        boolean removeFlag = this.addList.remove(set.getLocation());
        if (removeFlag) {
            --this.size;
        }
    }

    private void createTargetFile() {
        this.targetFile = new File(BirthmarkEnvironment.getStigmataHome(), "extracted_birthmarks/" + this.generateId() + ".xml");
        if (!this.targetFile.getParentFile().exists()) {
            this.targetFile.getParentFile().mkdirs();
        }
    }

    private synchronized void checkMode() {
        if (this.addmode) {
            this.addmode = false;
            this.formatter.printFooter(this.out);
            this.out.close();
            this.out = null;
            this.formatter = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BirthmarkSetStAXIterator
    implements Iterator<BirthmarkSet> {
        private XMLEventReader reader = null;
        private BirthmarkSet nextObject;
        private List<URL> validItems;
        private BirthmarkEnvironment env;
        private BirthmarkContext context;

        public BirthmarkSetStAXIterator(File file, List<URL> validItems, BirthmarkContext context) {
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                BufferedReader in = new BufferedReader(new FileReader(file));
                this.reader = factory.createXMLEventReader(in);
            }
            catch (FileNotFoundException factory) {
            }
            catch (XMLStreamException factory) {
                // empty catch block
            }
            this.validItems = validItems;
            this.context = context;
            this.env = context.getEnvironment();
            try {
                this.nextObject = this.findNext();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            boolean flag;
            boolean bl = flag = this.nextObject != null;
            if (!flag) {
                try {
                    this.reader.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            return flag;
        }

        @Override
        public BirthmarkSet next() {
            BirthmarkSet next = this.nextObject;
            try {
                this.nextObject = this.findNext();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            return next;
        }

        @Override
        public void remove() {
        }

        private BirthmarkSet findNext() throws XMLStreamException {
            String className = null;
            BirthmarkSet bs = null;
            Birthmark birthmark = null;
            BirthmarkSpi service = null;
            block2: while (this.reader.hasNext()) {
                block14: {
                    EndElement ee;
                    XMLEvent event;
                    block12: {
                        String type;
                        StartElement se;
                        block17: {
                            block16: {
                                block15: {
                                    block13: {
                                        ExtractionUnit unit;
                                        event = this.reader.peek();
                                        if (!event.isStartElement()) break block12;
                                        se = event.asStartElement();
                                        if (se.getName().getLocalPart().equals("unit") && (unit = ExtractionUnit.valueOf(this.reader.getElementText())) != null) {
                                            this.context.setExtractionUnit(unit);
                                        }
                                        if (!se.getName().getLocalPart().equals("birthmark-type")) break block13;
                                        type = this.reader.getElementText();
                                        if (this.env.getService(type) != null) {
                                            this.context.addBirthmarkType(type);
                                        }
                                        break block14;
                                    }
                                    if (!se.getName().getLocalPart().equals("name")) break block15;
                                    className = this.reader.getElementText();
                                    break block14;
                                }
                                if (!se.getName().getLocalPart().equals("location")) break block16;
                                String location = this.reader.getElementText();
                                if (className == null || location == null) {
                                    throw new XMLStreamException("incompatible with definition");
                                }
                                try {
                                    URL url = new URL(location);
                                    if (this.validItems == null || !this.validItems.contains(url)) {
                                        while (this.reader.hasNext()) {
                                            XMLEvent xmlevent = this.reader.nextTag();
                                            if (xmlevent.isEndElement() && xmlevent.asEndElement().getName().getLocalPart().equals("extracted-birthmark")) continue block2;
                                        }
                                        continue;
                                    }
                                    bs = new BirthmarkSet(className, url);
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                break block14;
                            }
                            if (!se.getName().getLocalPart().equals("element")) break block17;
                            if (service != null) {
                                BirthmarkElement be = service.buildBirthmarkElement(this.reader.getElementText());
                                birthmark.addElement(be);
                            }
                            break block14;
                        }
                        if (!se.getName().getLocalPart().equals("birthmark")) break block14;
                        type = se.getAttributeByName(new QName("type")).getValue();
                        service = this.env.getService(type);
                        if (service != null) {
                            birthmark = service.buildBirthmark();
                            bs.addBirthmark(birthmark);
                        } else {
                            birthmark = null;
                        }
                        break block14;
                    }
                    if (event.isEndElement() && (ee = event.asEndElement()).getName().getLocalPart().equals("extracted-birthmark")) {
                        this.reader.nextEvent();
                        break;
                    }
                }
                this.reader.nextEvent();
            }
            return bs;
        }
    }
}

