/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.comparators;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.birthmarks.comparators.AbstractBirthmarkComparator;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class DPMatchingBirthmarkComparator
extends AbstractBirthmarkComparator {
    private int mismatchPenalty = 5;
    private int shiftPenalty = 1;

    public DPMatchingBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    public int getMismatchPenalty() {
        return this.mismatchPenalty;
    }

    public void setMismatchPenalty(int mismatchPenalty) {
        this.mismatchPenalty = mismatchPenalty;
    }

    public int getShiftPenalty() {
        return this.shiftPenalty;
    }

    public void setShiftPenalty(int shiftPenalty) {
        this.shiftPenalty = shiftPenalty;
    }

    public double compare(Birthmark b1, Birthmark b2) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        if (element1.length > 0 && element2.length > 0) {
            int[][] cost = this.createCostMatrix(element1, element2);
            int max = (element1.length + element2.length) * (this.getMismatchPenalty() + this.getShiftPenalty());
            int distance = cost[element1.length - 1][element2.length - 1];
            return (double)(max - distance) / (double)max;
        }
        if (element1.length == 0 && element2.length == 0) {
            return 1.0;
        }
        return 0.0;
    }

    public int getCompareCount(Birthmark b1, Birthmark b2) {
        return b1.getElementCount() + b2.getElementCount();
    }

    private int[][] createCostMatrix(BirthmarkElement[] targetX, BirthmarkElement[] targetY) {
        int[][] mismatches = this.getMismatchMatrix(targetX, targetY);
        int[][] cost = new int[targetX.length][targetY.length];
        cost[0][0] = mismatches[0][0] * this.getMismatchPenalty();
        int i = 1;
        while (i < targetX.length) {
            cost[i][0] = cost[i - 1][0] + this.getShiftPenalty() + mismatches[i][0] * this.getMismatchPenalty();
            ++i;
        }
        i = 1;
        while (i < targetY.length) {
            cost[0][i] = cost[0][i - 1] + this.getShiftPenalty() + mismatches[0][i] * this.getMismatchPenalty();
            ++i;
        }
        i = 1;
        while (i < targetX.length) {
            int j = 1;
            while (j < targetY.length) {
                int crossCost = cost[i - 1][j - 1] + mismatches[i][j] * this.getMismatchPenalty();
                int horizontalCost = cost[i - 1][j] + mismatches[i][j] * this.getMismatchPenalty() + this.getShiftPenalty();
                int verticalCost = cost[i][j - 1] + mismatches[i][j] * this.getMismatchPenalty() + this.getShiftPenalty();
                cost[i][j] = crossCost <= horizontalCost && crossCost <= verticalCost ? crossCost : (horizontalCost <= verticalCost ? horizontalCost : verticalCost);
                ++j;
            }
            ++i;
        }
        return cost;
    }

    private int[][] getMismatchMatrix(BirthmarkElement[] targetX, BirthmarkElement[] targetY) {
        int[][] mismatches = new int[targetX.length][targetY.length];
        int i = 0;
        while (i < mismatches.length) {
            int j = 0;
            while (j < mismatches[i].length) {
                mismatches[i][j] = targetX[i] == null ? (targetY[j] == null ? 0 : 1) : (targetX[i].equals(targetY[j]) ? 0 : 1);
                ++j;
            }
            ++i;
        }
        return mismatches;
    }
}

