/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import java.util.Locale;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.birthmarks.NullBirthmarkElement;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.utils.LocalizedDescriptionManager;

public abstract class AbstractBirthmarkService
implements BirthmarkSpi {
    public String getDisplayType() {
        return this.getDisplayType(Locale.getDefault());
    }

    public String getDisplayType(Locale locale) {
        LocalizedDescriptionManager manager = LocalizedDescriptionManager.getInstance();
        String type = manager.getDisplayType(locale, this.getType());
        if (type == null) {
            type = this.getType();
        }
        return type;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        LocalizedDescriptionManager manager = LocalizedDescriptionManager.getInstance();
        String description = manager.getDescription(locale, this.getType());
        if (description == null) {
            description = this.getDefaultDescription();
        }
        return description;
    }

    public String getComparatorClassName() {
        return this.getComparator().getClass().getName();
    }

    public String getExtractorClassName() {
        return this.getExtractor().getClass().getName();
    }

    public abstract String getType();

    public abstract String getDefaultDescription();

    public boolean isExpert() {
        return true;
    }

    public boolean isUserDefined() {
        return true;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getVendorName() {
        return this.getClass().getPackage().getImplementationVendor();
    }

    public Birthmark buildBirthmark() {
        return this.getExtractor().createBirthmark();
    }

    public BirthmarkElement buildBirthmarkElement(String value) {
        if (value == null) {
            return NullBirthmarkElement.getInstance();
        }
        return new BirthmarkElement(value);
    }
}

