/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class PopupButton
extends JPanel {
    private static final long serialVersionUID = -4428839967597028837L;
    private JButton button;
    private JPopupMenu popup;
    private JButton arrowButton;
    private Icon icon;

    public PopupButton(JButton initButton) {
        this.setLayout(new BorderLayout());
        this.button = initButton;
        this.icon = this.createIcon();
        this.arrowButton = new JButton(this.icon);
        this.popup = new JPopupMenu();
        this.add((Component)this.button, "Center");
        this.add((Component)this.arrowButton, "East");
        this.arrowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Point p = PopupButton.this.button.getLocation();
                PopupButton.this.popup.show(PopupButton.this, p.x, PopupButton.this.button.getHeight());
            }
        });
        this.updateUI();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.arrowButton.setEnabled(enabled);
    }

    public JButton getButton() {
        return this.button;
    }

    public JMenuItem addMenuItem(JMenuItem menuItem) {
        return this.popup.add(menuItem);
    }

    public void updateUI() {
        super.updateUI();
        if (this.button != null) {
            Dimension prefferedSize = this.button.getPreferredSize();
            this.arrowButton.setPreferredSize(new Dimension(this.icon.getIconWidth() + 4, prefferedSize.height));
            this.setPreferredSize(new Dimension(prefferedSize.width + this.icon.getIconWidth() + 4, prefferedSize.height));
            Dimension maxSize = this.button.getMaximumSize();
            this.arrowButton.setMaximumSize(new Dimension(this.icon.getIconWidth() + 4, maxSize.height));
            this.setMaximumSize(new Dimension(maxSize.width + this.icon.getIconWidth() + 4, maxSize.height));
            Dimension minSize = this.button.getMinimumSize();
            this.arrowButton.setMaximumSize(new Dimension(this.icon.getIconWidth() + 4, minSize.height));
            this.setMinimumSize(new Dimension(minSize.width + this.icon.getIconWidth() + 4, minSize.height));
            this.arrowButton.setSize(this.arrowButton.getPreferredSize());
            this.setSize(this.getPreferredSize());
        }
    }

    private Icon createIcon() {
        BufferedImage image = new BufferedImage(10, 10, 2);
        Graphics2D g = image.createGraphics();
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 10;
        int[] x = nArray;
        int[] y = new int[]{3, 8, 3};
        Polygon polygon = new Polygon(x, y, x.length);
        g.setColor(Color.black);
        g.fill(polygon);
        return new ImageIcon(image);
    }
}

