/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.filter;

import java.util.ArrayList;
import java.util.List;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.filter.AbstractComparisonPairFilter;
import jp.naist.se.stigmata.filter.Criterion;
import jp.naist.se.stigmata.filter.FilterTarget;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;

public class TotalElementCountComparisonPairFilter
extends AbstractComparisonPairFilter {
    private static final List<Criterion> CRITERIA = new ArrayList<Criterion>();
    private int threshold = 0;
    private FilterTarget target;

    public TotalElementCountComparisonPairFilter(ComparisonPairFilterSpi service) {
        super(service);
    }

    public Criterion[] getAcceptableCriteria() {
        return TotalElementCountComparisonPairFilter.getValidCriteria();
    }

    public static Criterion[] getValidCriteria() {
        return CRITERIA.toArray(new Criterion[CRITERIA.size()]);
    }

    public boolean isFiltered(ComparisonPair pair) {
        boolean flag = this.getTarget() == FilterTarget.TARGET_1 ? this.checkFiltered(pair.getTarget1().getSumOfElementCount()) : (this.getTarget() == FilterTarget.TARGET_2 ? this.checkFiltered(pair.getTarget2().getSumOfElementCount()) : this.checkFiltered(pair.getTarget1().getSumOfElementCount(), pair.getTarget2().getSumOfElementCount()));
        return flag;
    }

    private boolean checkFiltered(int e1, int e2) {
        boolean flag2;
        boolean flag1;
        int t = this.getThreshold();
        switch (this.getCriterion()) {
            case GREATER_EQUALS: {
                flag1 = e1 >= t;
                flag2 = e2 >= t;
                break;
            }
            case GREATER_THAN: {
                flag1 = e1 > t;
                flag2 = e2 > t;
                break;
            }
            case LESS_EQUALS: {
                flag1 = e1 <= t;
                flag2 = e2 <= t;
                break;
            }
            case LESS_THAN: {
                flag1 = e1 < t;
                flag2 = e2 < t;
                break;
            }
            case EQUALS_AS: {
                flag1 = e1 == t;
                flag2 = e2 == t;
                break;
            }
            case NOT_EQUALS_AS: {
                flag1 = e1 != t;
                flag2 = e2 != t;
                break;
            }
            case MATCH: {
                flag2 = flag1 = e1 == e2;
                break;
            }
            case NOT_MATCH: {
                flag2 = flag1 = e1 != e2;
                break;
            }
            default: {
                flag1 = false;
                flag2 = false;
            }
        }
        return this.getTarget() == FilterTarget.BOTH_TARGETS && flag1 && flag2 || this.getTarget() == FilterTarget.ONE_OF_TARGETS && (flag1 || flag2);
    }

    private boolean checkFiltered(int total) {
        boolean flag = false;
        switch (this.getCriterion()) {
            case GREATER_EQUALS: {
                flag = total >= this.getThreshold();
                break;
            }
            case GREATER_THAN: {
                flag = total > this.getThreshold();
                break;
            }
            case LESS_EQUALS: {
                flag = total <= this.getThreshold();
                break;
            }
            case LESS_THAN: {
                flag = total < this.getThreshold();
                break;
            }
            case EQUALS_AS: {
                flag = total == this.getThreshold();
                break;
            }
            case NOT_EQUALS_AS: {
                flag = total != this.getThreshold();
                break;
            }
            default: {
                flag = false;
            }
        }
        return flag;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException("threshold must be positive value: " + threshold);
        }
        this.threshold = threshold;
    }

    public FilterTarget getTarget() {
        return this.target;
    }

    public void setTarget(FilterTarget target) {
        this.target = target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.getTarget()) {
            case TARGET_1: {
                sb.append("target1");
                break;
            }
            case TARGET_2: {
                sb.append("target2");
                break;
            }
            case BOTH_TARGETS: {
                sb.append("(target1&target2)");
                break;
            }
            case ONE_OF_TARGETS: {
                sb.append("(target1|target2)");
            }
        }
        sb.append(".element");
        switch (this.getCriterion()) {
            case GREATER_EQUALS: {
                sb.append(" >= ");
                break;
            }
            case GREATER_THAN: {
                sb.append(" >  ");
                break;
            }
            case LESS_EQUALS: {
                sb.append(" <= ");
                break;
            }
            case LESS_THAN: {
                sb.append(" <  ");
                break;
            }
            case EQUALS_AS: {
                sb.append(" == ");
                break;
            }
            case NOT_EQUALS_AS: {
                sb.append(" != ");
            }
        }
        sb.append(Integer.toString(this.getThreshold()));
        return new String(sb);
    }

    static {
        CRITERIA.add(Criterion.GREATER_EQUALS);
        CRITERIA.add(Criterion.GREATER_THAN);
        CRITERIA.add(Criterion.LESS_EQUALS);
        CRITERIA.add(Criterion.LESS_THAN);
        CRITERIA.add(Criterion.EQUALS_AS);
        CRITERIA.add(Criterion.NOT_EQUALS_AS);
        CRITERIA.add(Criterion.MATCH);
        CRITERIA.add(Criterion.NOT_MATCH);
    }
}

