/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.uc;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class UsedClassesBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    public UsedClassesBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkEnvironment environment) {
        super(visitor, birthmark, environment);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addSignatureClass(signature);
        if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(superName)) {
            this.add(superName);
        }
        String[] stringArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(i)) {
                this.add(i);
            }
            ++n2;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor visitor = super.visitField(access, name, desc, signature, value);
        this.addDescriptor(desc);
        this.addSignatureClass(signature);
        return visitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null) {
            String[] stringArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                String exception = stringArray[n2];
                if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(exception)) {
                    this.add(exception);
                }
                ++n2;
            }
        }
        this.addMethodDescriptor(desc);
        this.addSignatureClass(signature);
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(visitor){

            public void visitTypeInsn(int opcode, String desc) {
                Type type = Type.getType((String)("L" + desc + ";"));
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(desc);
                }
                super.visitTypeInsn(opcode, desc);
            }

            public void visitTryCatchBlock(Label start, Label end, Label handle, String desc) {
                Type type = Type.getType((String)("L" + desc + ";"));
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(UsedClassesBirthmarkExtractVisitor.this.getType(type));
                }
                super.visitTryCatchBlock(start, end, handle, desc);
            }

            public void visitMultiANewArrayInsn(String desc, int dims) {
                Type type = Type.getType((String)desc);
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(UsedClassesBirthmarkExtractVisitor.this.getType(type));
                }
                super.visitMultiANewArrayInsn(desc, dims);
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(Type.getType((String)desc))) {
                    UsedClassesBirthmarkExtractVisitor.this.add(desc);
                }
                UsedClassesBirthmarkExtractVisitor.this.addSignatureClass(signature);
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(owner)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(owner);
                }
                UsedClassesBirthmarkExtractVisitor.this.addDescriptor(desc);
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                String className = UsedClassesBirthmarkExtractVisitor.this.normalize(owner);
                if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(className)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(className);
                }
                UsedClassesBirthmarkExtractVisitor.this.addMethodDescriptor(desc);
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        };
    }

    private void addSignatureClass(String signature) {
        if (signature != null) {
            SignatureReader in = new SignatureReader(signature);
            SignatureWriter writer = new SignatureWriter(){

                public void visitClassType(String classType) {
                    if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(classType)) {
                        UsedClassesBirthmarkExtractVisitor.this.add(classType);
                    }
                }
            };
            in.accept((SignatureVisitor)writer);
        }
    }

    private void addMethodDescriptor(String desc) {
        Type returnType = Type.getReturnType((String)desc);
        Type[] args = Type.getArgumentTypes((String)desc);
        if (this.checkType(returnType)) {
            this.add(this.getType(returnType));
        }
        Type[] typeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Type arg = typeArray[n2];
            if (this.checkType(arg)) {
                this.add(this.getType(arg));
            }
            ++n2;
        }
    }

    private void addDescriptor(String desc) {
        Type type = Type.getType((String)desc);
        if (this.checkType(type)) {
            this.add(desc);
        }
    }

    private String getType(Type type) {
        if (type.getSort() == 9) {
            while (type.getSort() != 9) {
                type = type.getElementType();
            }
        }
        if (type.getSort() == 10) {
            return this.normalize(type.getClassName());
        }
        return null;
    }

    private boolean checkType(Type type) {
        if (type.getSort() == 9) {
            while (type.getSort() != 9) {
                type = type.getElementType();
            }
        }
        if (type.getSort() == 10) {
            String className = type.getClassName();
            if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(className)) {
                return true;
            }
        }
        return false;
    }

    private String normalize(String name) {
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        name = name.replace('/', '.');
        return name;
    }

    private void add(String name) {
        this.addElement(new BirthmarkElement(this.normalize(name)));
    }
}

