/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.birthmarks.ValueCountable;

public class FrequencyBirthmarkElement
extends BirthmarkElement
implements ValueCountable {
    private static final long serialVersionUID = 4454345943098520436L;
    private int count = 1;

    public FrequencyBirthmarkElement(String value) {
        super(FrequencyBirthmarkElement.parseValue(value));
        if (!value.equals(super.getValue())) {
            int number;
            this.count = number = new Integer(value.substring(0, value.indexOf(":"))).intValue();
        }
    }

    public FrequencyBirthmarkElement(String value, int count) {
        super(value);
        this.count = count;
    }

    void incrementValueCount() {
        ++this.count;
    }

    public boolean equals(Object o) {
        boolean flag = false;
        if (o instanceof FrequencyBirthmarkElement) {
            FrequencyBirthmarkElement fmbe = (FrequencyBirthmarkElement)o;
            flag = super.equals(fmbe) && this.getValueCount() == fmbe.getValueCount();
        }
        return flag;
    }

    public Object getValue() {
        return String.valueOf(this.getValueCount()) + ": " + this.getValueName();
    }

    public int hashCode() {
        int hash = super.hashCode();
        int shift = this.getValueCount() % 32;
        int i = 0;
        while (i < shift) {
            int v = hash & 1;
            hash = hash >>> 1 | v << 31;
            ++i;
        }
        return hash;
    }

    public String getValueName() {
        return (String)super.getValue();
    }

    public int getValueCount() {
        return this.count;
    }

    private static String parseValue(String value) {
        if (value.indexOf(":") > 0) {
            int index = value.indexOf(":");
            String num = value.substring(0, index);
            String val = value.substring(index + 1);
            try {
                new Integer(num);
                return val.trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }
}

