/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparisonFailedException;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractionFailedException;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.ExtractorNotFoundException;
import jp.naist.se.stigmata.FilterNotFoundException;
import jp.naist.se.stigmata.birthmarks.extractors.BirthmarkExtractorFactory;
import jp.naist.se.stigmata.event.BirthmarkEngineEvent;
import jp.naist.se.stigmata.event.BirthmarkEngineListener;
import jp.naist.se.stigmata.event.OperationStage;
import jp.naist.se.stigmata.event.OperationType;
import jp.naist.se.stigmata.event.WarningMessages;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.hook.Phase;
import jp.naist.se.stigmata.hook.StigmataHookManager;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.reader.DefaultClassFileArchive;
import jp.naist.se.stigmata.reader.JarClassFileArchive;
import jp.naist.se.stigmata.reader.WarClassFileArchive;
import jp.naist.se.stigmata.result.AbstractComparisonResultSet;
import jp.naist.se.stigmata.result.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.result.RoundRobinComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkEngine {
    private BirthmarkEnvironment environment;
    private List<BirthmarkEngineListener> listeners = new ArrayList<BirthmarkEngineListener>();
    private Stack<WarningMessages> stack = new Stack();
    private WarningMessages warnings;
    private OperationType latestOperationType;
    private OperationType targetType;
    private BirthmarkExtractorFactory factory;

    public BirthmarkEngine(BirthmarkEnvironment env) {
        this.environment = env;
        this.factory = new BirthmarkExtractorFactory(env);
    }

    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    public void addBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized ComparisonResultSet filter(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(target, context);
        crs = this.filter(crs);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonResultSet filter(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(targetX, targetY, context);
        crs = this.filter(crs);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonResultSet filter(ExtractionResultSet er) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(er);
        crs = this.filter(crs);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonResultSet filter(ComparisonResultSet crs) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        StigmataHookManager.getInstance().runHook(Phase.BEFORE_FILTERING, crs.getContext());
        String[] filterTypes = crs.getContext().getFilterTypes();
        if (filterTypes != null) {
            ArrayList<ComparisonPairFilterSet> filterList = new ArrayList<ComparisonPairFilterSet>();
            ComparisonPairFilterManager manager = this.environment.getFilterManager();
            for (int i = 0; i < filterTypes.length; ++i) {
                ComparisonPairFilterSet fset = manager.getFilterSet(filterTypes[i]);
                if (fset != null) {
                    filterList.add(fset);
                    continue;
                }
                this.warnings.addMessage(new FilterNotFoundException("filter not found"), filterTypes[i]);
            }
            ComparisonPairFilterSet[] cpfs = filterList.toArray(new ComparisonPairFilterSet[filterList.size()]);
            crs = new FilteredComparisonResultSet(crs, cpfs);
        }
        StigmataHookManager.getInstance().runHook(Phase.AFTER_FILTERING, crs.getContext());
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonPair compareDetails(BirthmarkSet bs1, BirthmarkSet bs2, BirthmarkContext context) throws BirthmarkComparisonFailedException {
        return new ComparisonPair(bs1, bs2, context);
    }

    public synchronized ComparisonResultSet compare(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ExtractionResultSet er = this.extract(target, context);
        ComparisonResultSet crs = this.compare(er);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonResultSet compare(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ExtractionResultSet er = this.extract(targetX, targetY, context);
        ComparisonResultSet crs = this.compare(er);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public synchronized ComparisonResultSet compare(ExtractionResultSet er) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        BirthmarkContext context = er.getContext();
        StigmataHookManager.getInstance().runHook(Phase.BEFORE_COMPARISON, context);
        AbstractComparisonResultSet crs = null;
        switch (context.getComparisonMethod()) {
            case ROUND_ROBIN_SAME_PAIR: {
                crs = new RoundRobinComparisonResultSet(er, true);
                break;
            }
            case ROUND_ROBIN_WITHOUT_SAME_PAIR: {
                crs = new RoundRobinComparisonResultSet(er, false);
                break;
            }
            case ROUND_ROBIN_XY: {
                crs = new RoundRobinComparisonResultSet(er, true);
            }
            case GUESSED_PAIR: {
                crs = new CertainPairComparisonResultSet(er);
                break;
            }
            case SPECIFIED_PAIR: {
                crs = new CertainPairComparisonResultSet(er, context.getNameMappings());
            }
        }
        StigmataHookManager.getInstance().runHook(Phase.AFTER_COMPARISON, context);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public synchronized ExtractionResultSet extract(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        ExtractionResultSet er = this.extract(target, null, context);
        this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        return er;
    }

    public synchronized ExtractionResultSet extract(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkStoreException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        ExtractionResultSet er = context.getEnvironment().getHistoryManager().createDefaultResultSet(context);
        try {
            Object targetXY;
            StigmataHookManager.getInstance().runHook(Phase.BEFORE_EXTRACTION, context);
            switch (context.getComparisonMethod()) {
                case ROUND_ROBIN_SAME_PAIR: 
                case ROUND_ROBIN_WITHOUT_SAME_PAIR: {
                    er.setTableType(false);
                    targetXY = this.mergeTarget(targetX, targetY);
                    this.extractImpl((String[])targetXY, er, ExtractionTarget.TARGET_XY);
                    break;
                }
                default: {
                    if (targetX == null || targetY == null) {
                        throw new BirthmarkExtractionFailedException("targetX or targetY is null");
                    }
                    er.setTableType(true);
                    this.extractImpl(targetX, er, ExtractionTarget.TARGET_X);
                    this.extractImpl(targetY, er, ExtractionTarget.TARGET_Y);
                }
            }
            targetXY = er;
            return targetXY;
        }
        catch (IOException e) {
            throw new BirthmarkExtractionFailedException(e);
        }
        finally {
            StigmataHookManager.getInstance().runHook(Phase.AFTER_EXTRACTION, context);
            this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        }
    }

    private String[] mergeTarget(String[] t1, String[] t2) {
        ArrayList<String> list = new ArrayList<String>();
        this.addToList(list, t1);
        this.addToList(list, t2);
        return list.toArray(new String[list.size()]);
    }

    private void addToList(List<String> list, String[] target) {
        if (target != null) {
            for (String s : target) {
                list.add(s);
            }
        }
    }

    private BirthmarkSet[] extractImpl(String[] target, ExtractionResultSet er, ExtractionTarget et) throws BirthmarkExtractionFailedException, IOException, BirthmarkStoreException {
        ClassFileArchive[] archives = this.createArchives(target, this.environment);
        BirthmarkContext context = er.getContext();
        ExtractionUnit unit = context.getExtractionUnit();
        BirthmarkSet[] extractResult = null;
        if (unit == ExtractionUnit.CLASS) {
            this.extractFromClass(archives, er, et);
        } else if (unit == ExtractionUnit.PACKAGE) {
            this.extractFromPackage(archives, er, et);
        } else if (unit == ExtractionUnit.ARCHIVE) {
            this.extractFromProduct(archives, er, et);
        }
        return extractResult;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] dataBuffer = new byte[512];
        while ((read = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
            bout.write(dataBuffer, 0, read);
        }
        byte[] data = bout.toByteArray();
        bout.close();
        return data;
    }

    private void extractFromPackage(ClassFileArchive[] archives, ExtractionResultSet er, ExtractionTarget et) throws IOException, BirthmarkExtractionFailedException {
        HashMap<String, BirthmarkSet> map = new HashMap<String, BirthmarkSet>();
        BirthmarkContext context = er.getContext();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    String name = entry.getClassName();
                    String packageName = this.parsePackageName(name);
                    BirthmarkSet bs = (BirthmarkSet)map.get(packageName);
                    if (bs == null) {
                        bs = new BirthmarkSet(packageName, archive.getLocation());
                        map.put(packageName, bs);
                    }
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (String birthmarkType : context.getBirthmarkTypes()) {
                        try {
                            BirthmarkExtractor extractor = this.factory.getExtractor(birthmarkType);
                            if (!extractor.isAcceptable(ExtractionUnit.PACKAGE)) continue;
                            Birthmark b = bs.getBirthmark(extractor.getProvider().getType());
                            if (b == null) {
                                b = extractor.createBirthmark();
                                bs.addBirthmark(b);
                            }
                            extractor.extract(b, new ByteArrayInputStream(data), er.getEnvironment());
                        }
                        catch (ExtractorNotFoundException e) {
                            this.warnings.addMessage(e, birthmarkType);
                        }
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, archive.getName());
                }
            }
        }
        try {
            for (BirthmarkSet bs : map.values()) {
                er.addBirthmarkSet(et, bs);
            }
        }
        catch (BirthmarkStoreException e) {
            // empty catch block
        }
    }

    private String parsePackageName(String name) {
        String n = name.replace('/', '.');
        int index = n.lastIndexOf(46);
        if (index > 0) {
            n = n.substring(0, index - 1);
        }
        return n;
    }

    private void extractFromClass(ClassFileArchive[] archives, ExtractionResultSet er, ExtractionTarget et) throws IOException, BirthmarkExtractionFailedException, BirthmarkStoreException {
        BirthmarkContext context = er.getContext();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    BirthmarkSet birthmarkset = new BirthmarkSet(entry.getClassName(), entry.getLocation());
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (String birthmarkType : context.getBirthmarkTypes()) {
                        try {
                            BirthmarkExtractor extractor = this.factory.getExtractor(birthmarkType);
                            if (!extractor.isAcceptable(ExtractionUnit.CLASS)) continue;
                            Birthmark b = extractor.extract(new ByteArrayInputStream(data), er.getEnvironment());
                            birthmarkset.addBirthmark(b);
                        }
                        catch (ExtractorNotFoundException e) {
                            this.warnings.addMessage(e, birthmarkType);
                        }
                    }
                    er.addBirthmarkSet(et, birthmarkset);
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
        }
    }

    private void extractFromProduct(ClassFileArchive[] archives, ExtractionResultSet er, ExtractionTarget et) throws IOException, BirthmarkExtractionFailedException, BirthmarkStoreException {
        BirthmarkContext context = er.getContext();
        for (ClassFileArchive archive : archives) {
            BirthmarkSet birthmarkset = new BirthmarkSet(archive.getName(), archive.getLocation());
            for (ClassFileEntry entry : archive) {
                try {
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (String birthmarkType : context.getBirthmarkTypes()) {
                        try {
                            BirthmarkExtractor extractor = this.factory.getExtractor(birthmarkType);
                            if (!extractor.isAcceptable(ExtractionUnit.ARCHIVE)) continue;
                            Birthmark b = birthmarkset.getBirthmark(birthmarkType);
                            if (b == null) {
                                b = extractor.createBirthmark();
                                birthmarkset.addBirthmark(b);
                            }
                            extractor.extract(b, new ByteArrayInputStream(data), er.getEnvironment());
                        }
                        catch (ExtractorNotFoundException e) {
                            this.warnings.addMessage(e, birthmarkType);
                        }
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
            if (birthmarkset.getBirthmarksCount() == 0) continue;
            er.addBirthmarkSet(et, birthmarkset);
        }
    }

    private ClassFileArchive[] createArchives(String[] files, BirthmarkEnvironment environment) throws IOException, MalformedURLException {
        ClasspathContext bytecode = environment.getClasspathContext();
        ArrayList<ClassFileArchive> archives = new ArrayList<ClassFileArchive>();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i].endsWith(".class")) {
                    archives.add(new DefaultClassFileArchive(files[i]));
                    continue;
                }
                if (files[i].endsWith(".jar") || files[i].endsWith(".zip")) {
                    archives.add(new JarClassFileArchive(files[i]));
                    bytecode.addClasspath(new File(files[i]).toURI().toURL());
                    continue;
                }
                if (!files[i].endsWith(".war")) continue;
                archives.add(new WarClassFileArchive(files[i]));
                continue;
            }
            catch (IOException e) {
                this.warnings.addMessage(e, files[i]);
            }
        }
        return archives.toArray(new ClassFileArchive[archives.size()]);
    }

    private void operationStart(OperationType type) {
        if (this.warnings == null) {
            this.warnings = new WarningMessages(type);
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_START, type, this.warnings));
            this.latestOperationType = type;
            this.targetType = type;
        }
        this.stack.push(this.warnings);
        if (this.latestOperationType != type) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_START, type, this.warnings));
            this.latestOperationType = type;
        }
    }

    private void operationDone(OperationType type) {
        if (this.latestOperationType != type && this.targetType != type) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_DONE, type, this.warnings));
            this.latestOperationType = type;
        }
        this.stack.pop();
        if (this.stack.size() == 0) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_DONE, type, this.warnings));
            this.warnings = null;
            this.latestOperationType = null;
        }
    }

    private void fireEvent(BirthmarkEngineEvent e) {
        block6: for (BirthmarkEngineListener listener : this.listeners) {
            switch (e.getStage()) {
                case OPERATION_START: {
                    listener.operationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_START: {
                    listener.subOperationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_DONE: {
                    listener.subOperationDone(e);
                    continue block6;
                }
                case OPERATION_DONE: {
                    listener.operationDone(e);
                    continue block6;
                }
            }
            throw new InternalError("unknown stage: " + (Object)((Object)e.getStage()));
        }
    }
}

