/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds.mark;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import jp.naist.se.stigmata.ui.swing.mds.GeometoryType;
import jp.naist.se.stigmata.ui.swing.mds.MarkDrawer;
import jp.naist.se.stigmata.ui.swing.mds.MarkIcon;
import jp.naist.se.stigmata.ui.swing.mds.mark.CircleDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.CrossDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.DownerTriangleDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.RectangleDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.RhombusDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.StarDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.UpperTriangleDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.XMarkDrawer;

public class DrawerFactory {
    private static final DrawerFactory instance = new DrawerFactory();
    private Map<GeometoryType, MarkDrawer> drawers = new HashMap<GeometoryType, MarkDrawer>();

    private DrawerFactory() {
        this.drawers.put(GeometoryType.CROSS, new CrossDrawer());
        this.drawers.put(GeometoryType.XMARK, new XMarkDrawer());
        this.drawers.put(GeometoryType.STAR, new StarDrawer());
        this.drawers.put(GeometoryType.CIRCLE, new CircleDrawer());
        this.drawers.put(GeometoryType.FILLED_CIRCLE, new CircleDrawer(true));
        this.drawers.put(GeometoryType.RHOMBUS, new RhombusDrawer());
        this.drawers.put(GeometoryType.FILLED_RHOMBUS, new RhombusDrawer(true));
        this.drawers.put(GeometoryType.RECTANGLE, new RectangleDrawer());
        this.drawers.put(GeometoryType.FILLED_RECTANGLE, new RectangleDrawer(true));
        this.drawers.put(GeometoryType.UPPER_TRIANGLE, new UpperTriangleDrawer());
        this.drawers.put(GeometoryType.FILLED_UPPER_TRIANGLE, new UpperTriangleDrawer(true));
        this.drawers.put(GeometoryType.DOWNER_TRIANGLE, new DownerTriangleDrawer());
        this.drawers.put(GeometoryType.FILLED_DOWNER_TRIANGLE, new DownerTriangleDrawer(true));
    }

    public static DrawerFactory getInstance() {
        return instance;
    }

    public MarkDrawer create(GeometoryType type) {
        return this.drawers.get((Object)type);
    }

    public Icon createIcon(GeometoryType type) {
        return new MarkIcon(this.create(type));
    }
}

