/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds.mark;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import jp.naist.se.stigmata.ui.swing.mds.MarkDrawer;

abstract class AbstractMarkDrawer
implements MarkDrawer {
    private boolean fill;

    public AbstractMarkDrawer() {
        this(false);
    }

    public AbstractMarkDrawer(boolean fill) {
        this.setFilled(fill);
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean fill) {
        this.fill = fill;
    }

    public abstract Shape getPlainShape(int var1, int var2);

    public abstract Shape getOveredShape(int var1, int var2);

    public Stroke getPlainStroke() {
        return null;
    }

    public Stroke getOverStroke() {
        return null;
    }

    public void draw(Graphics2D g, int w, int h) {
        Stroke s = this.getPlainStroke();
        if (s != null) {
            g.setStroke(s);
        }
        this.drawImpl(g, this.getPlainShape(w, h));
    }

    public void drawOver(Graphics2D g, int w, int h) {
        Stroke s = this.getOverStroke();
        if (s != null) {
            g.setStroke(s);
        }
        this.drawImpl(g, this.getOveredShape(w, h));
    }

    private void drawImpl(Graphics2D g, Shape s) {
        if (this.isFilled()) {
            g.fill(s);
        } else {
            g.draw(s);
        }
    }
}

