/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;

public class MDSMethod {
    private Matrix target;
    private Matrix coordinate;
    private Matrix eigenValues;
    private Matrix eigenVectors;
    private int[] indexes;

    public MDSMethod(Matrix matrix) {
        this.target = matrix;
    }

    protected Matrix getCenteredInnerProductMatrix() {
        Matrix centering = MDSMethod.getCenteringMatrix(this.target.getColumnDimension());
        Matrix trans = centering.transpose();
        return centering.times(this.target).times(trans).times(-1.0);
    }

    public Matrix getEigenValues() {
        if (this.eigenValues == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenValues.clone();
    }

    public Matrix getEigenVectors() {
        if (this.eigenVectors == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenVectors.clone();
    }

    public double[] getCoordinate(int axis) {
        if (this.coordinate == null) {
            this.getCoordinateMatrix();
        }
        double[] v = new double[this.coordinate.getRowDimension()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.coordinate.get(i, this.indexes[axis]);
        }
        return v;
    }

    public Matrix getCoordinateMatrix() {
        if (this.coordinate == null) {
            Matrix mat = this.getCenteredInnerProductMatrix();
            EigenvalueDecomposition eigen = mat.eig();
            Matrix eigenVectors = eigen.getV();
            Matrix eigenValues = eigen.getD();
            Matrix coordinate = (Matrix)eigenVectors.clone();
            int col = mat.getColumnDimension();
            int row = mat.getRowDimension();
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    double v = coordinate.get(i, j);
                    coordinate.set(i, j, v *= Math.sqrt(eigenValues.get(j, j)));
                }
            }
            this.sortValues(eigenValues);
            this.coordinate = coordinate;
            this.eigenVectors = eigenVectors;
            this.eigenValues = eigenValues;
        }
        return this.coordinate;
    }

    protected static Matrix getCenteringMatrix(int n) {
        Matrix matrix = Matrix.identity((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix.set(i, j, matrix.get(i, j) - 1.0 / (double)n);
            }
        }
        return matrix;
    }

    private void sortValues(Matrix m) {
        int i;
        double[] v = new double[m.getColumnDimension()];
        int[] index = new int[v.length];
        for (i = 0; i < v.length; ++i) {
            v[i] = m.get(i, i);
            index[i] = i;
        }
        for (i = 0; i < v.length; ++i) {
            for (int j = i + 1; j < v.length; ++j) {
                if (!(Math.abs(v[i]) < Math.abs(v[j]))) continue;
                double tmpValue = v[j];
                v[j] = v[i];
                v[i] = tmpValue;
                int tmpIndex = index[j];
                index[j] = index[i];
                index[i] = tmpIndex;
            }
        }
        this.indexes = index;
    }
}

