/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.ui.swing.Messages;

public class Utility {
    private static final String iconPath = Messages.getString("icon.directory");

    private Utility() {
    }

    public static void decorateJComponent(JComponent component, String label) {
        if (Messages.hasString(label + ".tooltip")) {
            component.setToolTipText(Messages.getString(label + ".tooltip"));
        }
        if (Messages.hasString(label + ".border")) {
            component.setBorder(new TitledBorder(Messages.getString(label + ".border")));
        }
        try {
            Method[] methods = component.getClass().getMethods();
            Icon icon = Utility.getIcon(label + ".icon");
            if (icon != null) {
                for (Method m : methods) {
                    if (!m.getName().equals("setIcon")) continue;
                    m.invoke((Object)component, icon);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static JButton createButton(String label, Action action) {
        Icon icon;
        JButton button = new JButton(action);
        button.setText(Messages.getString(label + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(label + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(label + ".button.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JButton createButton(String label) {
        Icon icon;
        JButton button = new JButton(Messages.getString(label + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(label + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(label + ".button.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label) {
        return Utility.createJCheckBoxMenuItem(label, false);
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label, boolean status) {
        Icon icon;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString(label + ".menuitem.label"), status);
        item.setActionCommand(label);
        if (Messages.hasString(label + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(label + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label, Action action) {
        Icon icon;
        JMenuItem item = new JMenuItem(action);
        item.setText(Messages.getString(label + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(label + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(label + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label) {
        Icon icon;
        JMenuItem item = new JMenuItem(Messages.getString(label + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(label + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(label + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenu createJMenu(String label) {
        Icon icon;
        JMenu menu = new JMenu(Messages.getString(label + ".menu.label"));
        menu.setActionCommand(label);
        if (Messages.hasString(label + ".menu.tooltip")) {
            menu.setToolTipText(Messages.getString(label + ".menu.tooltip"));
        }
        if ((icon = Utility.getIcon(label + ".menu.icon")) != null) {
            menu.setIcon(icon);
        }
        return menu;
    }

    public static Icon getIcon(String label) {
        if (Messages.hasString(label)) {
            String iconFile = Messages.getString(label);
            ImageIcon icon = new ImageIcon(Utility.class.getResource(iconPath + iconFile));
            return icon;
        }
        return null;
    }

    public static Image getImage(String imageFilePathLabel) {
        if (Messages.hasString(imageFilePathLabel)) {
            String imageFilePath = Messages.getString(imageFilePathLabel);
            ImageIcon icon = new ImageIcon(Utility.class.getResource(iconPath + imageFilePath));
            return icon.getImage();
        }
        return null;
    }

    public static String array2String(String[] values) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(values[i]);
        }
        return new String(builder);
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp) {
        Utility.addNewTab(key, tabPane, comp, null, null);
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp, Object[] tabnameValues, Object[] values) {
        String tabName = Messages.getString(key + ".tab.label");
        String tooltip = Messages.getString(key + ".tab.tooltip");
        Icon icon = Utility.getIcon(key + ".tab.icon");
        if (tabnameValues != null) {
            tabName = MessageFormat.format(tabName, tabnameValues);
        }
        if (values != null) {
            tooltip = MessageFormat.format(tooltip, values);
        }
        tabPane.addTab(tabName, icon, comp, tooltip);
    }
}

