/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class TargetSelectionPane
extends JPanel {
    private static final long serialVersionUID = 3209435745432235432L;
    private StigmataFrame stigmata;
    private FileFilter[] filters;
    private List<String> extensions = new ArrayList<String>();
    private String description;
    private DefaultListModel model = new DefaultListModel();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean directorySelectable = false;
    private boolean multipleSelectable = true;
    private JList list;
    private JButton addButton;
    private JButton removeButton;

    public TargetSelectionPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initComponents();
        this.list.setModel(this.model);
        TargetSelectionDropTarget dropTarget = new TargetSelectionDropTarget();
        this.list.setDropTarget(dropTarget);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.list, 2, new TargetDragGestureListener(this.list, this.model));
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeAllElements() {
        this.model.removeAllElements();
        this.fireEvent();
    }

    public void setFileFilter(FileFilter filter) {
        this.setFileFilters(new FileFilter[]{filter});
    }

    public void setFileFilters(FileFilter[] filters) {
        this.filters = filters;
    }

    public FileFilter[] getFileFilters() {
        if (this.filters == null) {
            String[] exts = this.getExtensions();
            this.filters = new FileFilter[exts.length];
            int i = 0;
            while (i < exts.length) {
                this.filters[i] = new ExtensionFilter(exts[i], MessageFormat.format(this.getSelectDescription(), exts[i]));
                ++i;
            }
        }
        return this.filters;
    }

    public void addTargetExtension(String ext) {
        if (this.filters != null) {
            this.filters = null;
        }
        this.extensions.add(ext);
    }

    public void addTargetExtensions(String[] exts) {
        if (this.filters != null) {
            this.filters = null;
        }
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            this.extensions.add(ext);
            ++n2;
        }
    }

    public synchronized String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public void setSelectDescription(String description) {
        this.description = description;
    }

    public String getSelectDescription() {
        return this.description;
    }

    public String[] getValues() {
        String[] strings = new String[this.model.getSize()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = (String)this.model.getElementAt(i);
            ++i;
        }
        return strings;
    }

    public String[] getSelectedValues() {
        int[] indeces = this.list.getSelectedIndices();
        String[] strings = new String[indeces.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = (String)this.model.getElementAt(indeces[i]);
            ++i;
        }
        return strings;
    }

    public void addValues(String[] values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.addValue(value);
            ++n2;
        }
    }

    public void addValue(String value) {
        this.model.addElement(value);
        this.fireEvent();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(flag);
        this.list.setEnabled(flag);
    }

    public void setDirectorySelectable(boolean flag) {
        this.directorySelectable = flag;
    }

    public boolean isDirectorySelectable() {
        return this.directorySelectable;
    }

    public void setMultipleSelectable(boolean flag) {
        this.multipleSelectable = flag;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    private void fireEvent() {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            DataChangeListener listener = this.listeners.get(i);
            listener.valueChanged(this.model);
            --i;
        }
    }

    private void initComponents() {
        JScrollPane scroll = new JScrollPane();
        Box south = Box.createHorizontalBox();
        this.list = new JList();
        this.addButton = Utility.createButton("addpackage");
        this.removeButton = Utility.createButton("removepackage");
        this.removeButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        scroll.setViewportView(this.list);
        this.add((Component)scroll, "Center");
        south.add(Box.createHorizontalGlue());
        south.add(this.addButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.removeButton);
        south.add(Box.createHorizontalGlue());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TargetSelectionPane.this.listValueChanged(evt);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.removeButtonActionPerformed(evt);
            }
        });
        this.add((Component)south, "South");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        if (indeces != null && indeces.length >= 1) {
            int i = indeces.length - 1;
            while (i >= 0) {
                this.model.removeElementAt(indeces[i]);
                this.fireEvent();
                --i;
            }
        }
        this.removeButton.setEnabled(false);
    }

    private void listValueChanged(ListSelectionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        this.removeButton.setEnabled(this.isEnabled() && indeces != null);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        File[] files;
        File[] fileArray = files = this.stigmata.openFiles(this.getFileFilters(), true, true);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addValue(file.getPath());
            ++n2;
        }
    }

    private class DataRemoveWhenDragSuccessfulAdapter
    extends DragSourceAdapter {
        private DefaultListModel model;
        private int[] indeces;

        public DataRemoveWhenDragSuccessfulAdapter(DefaultListModel model, int[] indeces) {
            this.model = model;
            this.indeces = indeces;
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            int i = this.indeces.length - 1;
            while (i >= 0) {
                this.model.removeElementAt(this.indeces[i]);
                --i;
            }
            TargetSelectionPane.this.fireEvent();
            super.dragDropEnd(dsde);
        }
    }

    private class TargetDragGestureListener
    implements DragGestureListener {
        private JList list;

        public TargetDragGestureListener(JList list, DefaultListModel model) {
            this.list = list;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            int[] indeces = this.list.getSelectedIndices();
            if (indeces.length > 0) {
                String[] strings = new String[indeces.length];
                int i = 0;
                while (i < strings.length) {
                    strings[i] = (String)TargetSelectionPane.this.model.getElementAt(indeces[i]);
                    ++i;
                }
                TargetTransferable transferable = new TargetTransferable(strings);
                DataRemoveWhenDragSuccessfulAdapter listener = new DataRemoveWhenDragSuccessfulAdapter(TargetSelectionPane.this.model, indeces);
                dge.startDrag(DragSource.DefaultMoveDrop, transferable, listener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TargetSelectionDropTarget
    extends DropTarget {
        private static final long serialVersionUID = 3204457621345L;

        private TargetSelectionDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent arg0) {
        }

        @Override
        public void dragExit(DropTargetEvent arg0) {
        }

        @Override
        public void dragOver(DropTargetDragEvent arg0) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent arg0) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Transferable trans = dtde.getTransferable();
            try {
                List list;
                List<String> errorList;
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (errorList = this.checkAndAddDroppedFile(list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor))).size() > 0) {
                    this.showError(errorList);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private List<String> checkAndAddDroppedFile(List list) {
            ArrayList<String> errorList = new ArrayList<String>();
            FileFilter[] filters = TargetSelectionPane.this.getFileFilters();
            int i = 0;
            while (i < list.size()) {
                File file = (File)list.get(i);
                boolean neverAddedFlag = true;
                FileFilter[] fileFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    FileFilter filter = fileFilterArray[n2];
                    if (filter.accept(file)) {
                        TargetSelectionPane.this.addValue(file.getPath());
                        neverAddedFlag = false;
                    }
                    ++n2;
                }
                if (neverAddedFlag) {
                    errorList.add(file.getName());
                }
                ++i;
            }
            return errorList;
        }

        private void showError(List<String> errorList) {
            StringBuilder builder = new StringBuilder("<html><body>");
            builder.append(Messages.getString("unsupportedfiletype.dialog.message"));
            builder.append("<ul>");
            int i = 0;
            while (i < errorList.size()) {
                builder.append("<li>").append(errorList.get(i)).append("</li>");
                ++i;
            }
            builder.append("</ul></body></html>");
            JOptionPane.showMessageDialog(TargetSelectionPane.this, new String(builder), Messages.getString("unsupportedfiletype.dialog.title"), 0);
        }
    }

    private class TargetTransferable
    implements Transferable {
        private String[] strings;

        public TargetTransferable(String[] strings) {
            this.strings = strings;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            ArrayList<File> list = new ArrayList<File>();
            int i = 0;
            while (i < this.strings.length) {
                list.add(new File(this.strings[i]));
                ++i;
            }
            return list;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.javaFileListFlavor);
        }
    }
}

