/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.BirthmarkElementClassNotFoundException;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractionFailedException;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.event.BirthmarkEngineAdapter;
import jp.naist.se.stigmata.event.BirthmarkEngineEvent;
import jp.naist.se.stigmata.event.WarningMessages;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.ui.swing.BirthmarkExtractionResultPane;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.ControlPane;
import jp.naist.se.stigmata.ui.swing.FileIOManager;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PairComparisonPane;
import jp.naist.se.stigmata.ui.swing.PairComparisonResultSetPane;
import jp.naist.se.stigmata.ui.swing.RoundRobinComparisonResultPane;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.AboutAction;
import jp.naist.se.stigmata.ui.swing.actions.LicenseAction;
import jp.naist.se.stigmata.ui.swing.graph.SimilarityDistributionGraphPane;
import jp.naist.se.stigmata.ui.swing.mds.MDSGraphPanel;
import jp.naist.se.stigmata.ui.swing.tab.EditableTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StigmataFrame
extends JFrame {
    private static final long serialVersionUID = 92345543665342134L;
    private JTabbedPane tabPane;
    private JMenuItem closeTabMenu;
    private JCheckBoxMenuItem expertmodeMenu;
    private Stigmata stigmata;
    private BirthmarkEnvironment environment;
    private ControlPane control;
    private FileIOManager fileio;
    private Map<String, Integer> countmap = new HashMap<String, Integer>();

    public StigmataFrame() {
        this(Stigmata.getInstance());
    }

    public StigmataFrame(Stigmata stigmata) {
        this(stigmata, stigmata.createEnvironment());
    }

    public StigmataFrame(Stigmata stigmata, BirthmarkEnvironment environment) {
        this.stigmata = stigmata;
        this.environment = environment;
        this.fileio = new FileIOManager(this);
        Image iconImage = Utility.getImage("stigmata.icon");
        if (iconImage != null) {
            this.setIconImage(iconImage);
        }
        stigmata.addBirthmarkEngineListener(new BirthmarkEngineAdapter(){

            public void operationDone(BirthmarkEngineEvent e) {
                StigmataFrame.this.showWarnings(e.getMessage());
            }
        });
        this.initLayouts();
    }

    public Stigmata getStigmata() {
        return this.stigmata;
    }

    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    public File getCurrentDirectory() {
        return this.fileio.getCurrentDirectory();
    }

    public void setCurrentDirectory(File file) {
        try {
            this.fileio.setCurrentDirectory(file);
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, Messages.getString("notdirectory.dialog.message", file.getName()), Messages.getString("notdirectory.dialog.title"), 0);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public File[] openFiles(FileFilter[] filters, boolean multipleSelectable, boolean directorySelectable) {
        return this.fileio.openFiles(filters, multipleSelectable, directorySelectable);
    }

    public File getOpenFile(String[] exts, String desc) {
        return this.fileio.findFile(true, exts, desc);
    }

    public File getSaveFile(String[] exts, String desc) {
        return this.fileio.findFile(false, exts, desc);
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.removeBirthmarkServiceListener(listener);
    }

    public void compareDetails(BirthmarkSet target1, BirthmarkSet target2, BirthmarkEnvironment environment) {
        PairComparisonPane detail = new PairComparisonPane(this, new ComparisonPair(target1, target2, environment));
        int compareDetail = this.getNextCount("compare_detail");
        Utility.addNewTab("comparedetail", this.tabPane, detail, new Object[]{new Integer(compareDetail)}, new Object[]{Utility.array2String(target1.getBirthmarkTypes()), target1.getName(), target2.getName()});
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkEnvironment environment) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, environment);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, environment);
            RoundRobinComparisonResultPane compare = new RoundRobinComparisonResultPane(this, environment, x, y);
            int compareCount = this.getNextCount("compare");
            Utility.addNewTab("compare", this.tabPane, compare, new Object[]{new Integer(compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, String[] filterNames, BirthmarkEnvironment environment) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, environment);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, environment);
            ComparisonPairFilterSet[] filters = environment.getFilterManager().getFilterSets(filterNames);
            ComparisonResultSet resultset = this.stigmata.compare(x, y, environment);
            FilteredComparisonResultSet fcrs = new FilteredComparisonResultSet(resultset, filters);
            int compareCount = this.getNextCount("compare");
            Utility.addNewTab("compare", this.tabPane, new PairComparisonResultSetPane(this, fcrs), new Object[]{new Integer(compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareGuessedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkEnvironment environment) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, environment);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, environment);
            int comparePair = this.getNextCount("compare_pair");
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, environment);
            Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareSpecifiedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkEnvironment environment) {
        File file = this.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.constructMapping(file);
            try {
                BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, environment);
                BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, environment);
                int comparePair = this.getNextCount("compare_pair");
                CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, mapping, environment);
                Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
                this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
            }
            catch (Exception e) {
                this.showExceptionMessage(e);
            }
        }
    }

    public void showComparisonResultSet(ComparisonResultSet resultset) {
        int comparePair = this.getNextCount("compare_pair");
        Utility.addNewTab("comparisonresultset", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(comparePair)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showMDSGraph(BirthmarkSet[] set) {
        try {
            MDSGraphPanel panel = new MDSGraphPanel(this, set, this.environment);
            int mappingGraphCount = this.getNextCount("mds_graph");
            Utility.addNewTab("mappinggraph", this.tabPane, panel, new Object[]{new Integer(mappingGraphCount)}, null);
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void showSimilarityDistributionGraph(Map<Integer, Integer> distributions) {
        SimilarityDistributionGraphPane graph = new SimilarityDistributionGraphPane(this, distributions);
        int similarityGraphCount = this.getNextCount("similarity_graph");
        Utility.addNewTab("similaritygraph", this.tabPane, graph, new Object[]{new Integer(similarityGraphCount)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showExtractionResult(BirthmarkSet[] set, BirthmarkEnvironment environment) {
        int extractCount = this.getNextCount("extract");
        BirthmarkExtractionResultPane viewer = new BirthmarkExtractionResultPane(this, environment, set);
        Utility.addNewTab("extract", this.tabPane, viewer, new Object[]{new Integer(extractCount)}, new Object[]{Utility.array2String(set[0].getBirthmarkTypes())});
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void extract(String[] birthmarks, String[] targets, BirthmarkEnvironment environment) {
        try {
            BirthmarkSet[] holders = this.stigmata.extract(birthmarks, targets, environment);
            this.showExtractionResult(holders, environment);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> constructMapping(File file) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(", *");
                if (tokens.length < 2) continue;
                mapping.put(tokens[0], tokens[1]);
            }
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return mapping;
    }

    private void initLayouts() {
        this.setTitle(Messages.getString("stigmata.frame.title"));
        this.initComponents();
        this.control = new ControlPane(this);
        Utility.addNewTab("control", this.tabPane, this.control, null, null);
        this.control.inititalize();
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        this.setSize(900, 600);
    }

    private void showWarnings(WarningMessages warnings) {
        if (warnings.getWarningCount() > 0) {
            StringBuilder sb = new StringBuilder("<html><body><dl>");
            Iterator<Exception> i = warnings.exceptions();
            while (i.hasNext()) {
                Exception e = i.next();
                sb.append("<dt>").append(e.getClass().getName()).append("</dt>");
                sb.append("<dd>").append(e.getMessage()).append("</dd>");
                sb.append("<dd>").append(warnings.getString(e)).append("</dd>");
            }
            sb.append("</dl></body></html>");
            JOptionPane.showMessageDialog(this, new String(sb), Messages.getString("warning.dialog.title"), 2);
        }
    }

    private void initComponents() {
        this.setDefaultUI();
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createHelpMenu());
        this.setJMenuBar(menubar);
        this.tabPane = new EditableTabbedPane(this);
        this.add((Component)this.tabPane, "Center");
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String title = StigmataFrame.this.tabPane.getTitleAt(StigmataFrame.this.tabPane.getSelectedIndex());
                StigmataFrame.this.closeTabMenu.setEnabled(!title.equals(Messages.getString("control.tab.label")));
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = Utility.createJMenu("fileMenu");
        JMenuItem newFrameMenu = Utility.createJMenuItem("newframe");
        JMenuItem exportMenu = Utility.createJMenuItem("exportsetting");
        JMenuItem closeTabMenu = Utility.createJMenuItem("closetab");
        JMenuItem closeMenu = Utility.createJMenuItem("closeframe");
        JMenuItem exitMenu = Utility.createJMenuItem("exit");
        this.closeTabMenu = closeTabMenu;
        fileMenu.add(newFrameMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exportMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeTabMenu);
        fileMenu.add(closeMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitMenu);
        newFrameMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame frame = new StigmataFrame(StigmataFrame.this.stigmata, StigmataFrame.this.environment);
                frame.setVisible(true);
            }
        });
        exportMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.control.exportSettings();
            }
        });
        closeTabMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeTabMenuActionPerformed();
            }
        });
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.setVisible(false);
                StigmataFrame.this.dispose();
            }
        });
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = Utility.createJMenu("helpmenu");
        JMenuItem about = Utility.createJMenuItem("about", new AboutAction(this));
        JMenuItem license = Utility.createJMenuItem("license", new LicenseAction(this));
        JMenuItem help = Utility.createJMenuItem("helpmenu");
        this.expertmodeMenu = Utility.createJCheckBoxMenuItem("expertmenu");
        menu.add(about);
        menu.add(license);
        menu.add(help);
        menu.add(new JSeparator());
        menu.add(this.createLookAndFeelMenu());
        menu.add(new JSeparator());
        menu.add(this.expertmodeMenu);
        this.expertmodeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.expertMenuActionPerformed(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        help.setEnabled(false);
        return menu;
    }

    private JMenu createLookAndFeelMenu() {
        JMenu laf = Utility.createJMenu("lookandfeel");
        ButtonGroup bg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        LookAndFeel lookfeel = UIManager.getLookAndFeel();
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String command = e.getActionCommand();
                    UIManager.setLookAndFeel(command);
                    SwingUtilities.updateComponentTreeUI(StigmataFrame.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        for (int i = 0; i < info.length; ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(info[i].getName());
            item.setActionCommand(info[i].getClassName());
            item.addActionListener(listener);
            bg.add(item);
            laf.add(item);
            if (!info[i].getClassName().equals(lookfeel.getClass().getName())) continue;
            item.setState(true);
        }
        return laf;
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmodeMenu.setState(expertmode);
    }

    private void expertMenuActionPerformed(boolean status) {
        this.control.setExpertMode(status);
    }

    private void showExceptionMessage(Exception e) {
        if (e instanceof BirthmarkElementClassNotFoundException) {
            this.showClassNotFoundMessage((BirthmarkElementClassNotFoundException)e);
            return;
        }
        JTextArea area = new JTextArea(20, 60);
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        e.printStackTrace(out);
        if (e instanceof BirthmarkExtractionFailedException) {
            out.println("Causes:");
            for (Throwable t : ((BirthmarkExtractionFailedException)e).getCauses()) {
                t.printStackTrace(out);
            }
        }
        out.close();
        area.setText(writer.toString());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html><body><p>" + Messages.getString("error.message.contactus") + "</p></body></html>"), "North");
        panel.add((Component)new JScrollPane(area), "Center");
        JOptionPane.showMessageDialog(this, panel, Messages.getString("error.dialog.title"), 2);
    }

    private void showClassNotFoundMessage(BirthmarkElementClassNotFoundException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><p>");
        sb.append(Messages.getString("error.message.classpath"));
        sb.append("</p><ul>");
        for (String name : e.getClassNames()) {
            sb.append("<li>").append(name).append("</li>");
        }
        sb.append("</ul></body></html>");
        JOptionPane.showMessageDialog(this, new String(sb), Messages.getString("error.dialog.title"), 2);
    }

    private void closeTabMenuActionPerformed() {
        int index = this.tabPane.getSelectedIndex();
        if (index == 0) {
            JOptionPane.showMessageDialog(this, Messages.getString("cannotclosecontroltab.dialog.message"), Messages.getString("cannotclosecontroltab.dialog.title"), 0);
        } else {
            this.tabPane.removeTabAt(index);
        }
    }

    private int getNextCount(String label) {
        Integer i = this.countmap.get(label);
        if (i == null) {
            i = new Integer(0);
        }
        i = i + 1;
        this.countmap.put(label, i);
        return i;
    }

    private void setDefaultUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

