/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelection;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class BirthmarkSelectionCheckSetPane
extends BirthmarkSelectablePane {
    private static final long serialVersionUID = 3209854654743223453L;
    private JPanel checks = new JPanel();

    public BirthmarkSelectionCheckSetPane(StigmataFrame stigmata) {
        super(stigmata);
        this.initLayouts();
    }

    private void initLayouts() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.checks, "Center");
        JButton checkAll = Utility.createButton("checkall");
        JButton uncheckAll = Utility.createButton("uncheckall");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(checkAll);
        box.add(Box.createHorizontalGlue());
        box.add(uncheckAll);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "South");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean flag = e.getActionCommand().equals("checkall");
                Iterator<BirthmarkSelection> i = BirthmarkSelectionCheckSetPane.this.birthmarkSelections();
                while (i.hasNext()) {
                    BirthmarkSelection le = i.next();
                    le.setSelected(flag);
                    BirthmarkSelectionCheckSetPane.this.fireEvent();
                }
                BirthmarkSelectionCheckSetPane.this.updateLayouts();
            }
        };
        checkAll.addActionListener(listener);
        uncheckAll.addActionListener(listener);
    }

    protected void updateLayouts() {
        this.checks.removeAll();
        Dimension d = this.calculateDimension();
        this.checks.setLayout(new GridLayout(d.height, d.width));
        Iterator<BirthmarkSelection> i = this.birthmarkSelections();
        while (i.hasNext()) {
            final BirthmarkSelection elem = i.next();
            if (elem.isVisible(this.isExpertMode())) {
                JCheckBox check = new JCheckBox(elem.getService().getDisplayType());
                check.setSelected(elem.isSelected());
                check.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JCheckBox c = (JCheckBox)e.getSource();
                        BirthmarkSelectionCheckSetPane.this.select(elem.getService().getType(), c.isSelected());
                        BirthmarkSelectionCheckSetPane.this.fireEvent();
                    }
                });
                this.checks.add(check);
            }
            this.select(elem.getType(), elem.isVisible(this.isExpertMode()) && elem.isSelected());
        }
        this.updateUI();
    }

    private Dimension calculateDimension() {
        int rows = 1;
        int cols = 0;
        Iterator<BirthmarkSelection> i = this.birthmarkSelections();
        while (i.hasNext()) {
            BirthmarkSelection selection = i.next();
            if (!selection.isVisible(this.isExpertMode())) continue;
            ++cols;
        }
        if (cols > 4) {
            rows = cols / 3;
            if (cols % 3 != 0) {
                ++rows;
            }
            cols = 3;
        }
        return new Dimension(cols, rows);
    }
}

