/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassFileArchive
implements ClassFileArchive {
    private File file;
    private String className;

    public DefaultClassFileArchive(String file) {
        this(new File(file));
    }

    public DefaultClassFileArchive(File file) {
        this.file = file;
        this.parseClassName();
    }

    public DefaultClassFileArchive(String file, String className) {
        this(new File(file), className);
    }

    public DefaultClassFileArchive(File file, String className) {
        this.file = file;
        this.className = className;
    }

    @Override
    public URL getLocation() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream(ClassFileEntry entry) throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public Iterator<ClassFileEntry> iterator() {
        ArrayList<ClassFileEntry> list = new ArrayList<ClassFileEntry>();
        list.add(new ClassFileEntry(this.className, this.getLocation()));
        return list.iterator();
    }

    @Override
    public boolean hasEntry(String className) {
        return this.className.equals(className);
    }

    @Override
    public ClassFileEntry getEntry(String className) throws ClassNotFoundException {
        return new ClassFileEntry(className, this.getLocation());
    }

    @Override
    public String getName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseClassName() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            ClassReader reader = new ClassReader((InputStream)in);
            ClassNameExtractVisitor visitor = new ClassNameExtractVisitor();
            reader.accept((ClassVisitor)visitor, true);
            this.className = visitor.getClassName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class ClassNameExtractVisitor
    extends EmptyVisitor {
        private String className;

        private ClassNameExtractVisitor() {
        }

        public String getClassName() {
            return this.className;
        }

        public void visit(int version, int access, String name, String signature, String superClassName, String[] interfaces) {
            this.className = name;
        }
    }
}

