/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredComparisonResultSet
implements ComparisonResultSet {
    private ComparisonResultSet resultset;
    private List<ComparisonPairFilterSet> filters = new ArrayList<ComparisonPairFilterSet>();

    public FilteredComparisonResultSet(ComparisonResultSet resultset) {
        this.resultset = resultset;
    }

    public FilteredComparisonResultSet(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters) {
        this.resultset = resultset;
        for (int i = 0; i < filters.length; ++i) {
            this.addFilterSet(filters[i]);
        }
    }

    public void addFilterSet(ComparisonPairFilterSet filter) {
        this.filters.add(filter);
    }

    public void removeFilterSet(ComparisonPairFilterSet filter) {
        this.filters.remove(filter);
    }

    @Override
    public int getComparisonCount() {
        return this.resultset.getComparisonCount();
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.resultset.getEnvironment();
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return new FilteredIterator(this.resultset.iterator());
    }

    @Override
    public BirthmarkSet[] getComparisonSources() {
        return this.resultset.getComparisonSources();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredIterator
    implements Iterator<ComparisonPair> {
        private Iterator<ComparisonPair> iterator;
        private ComparisonPair next;

        public FilteredIterator(Iterator<ComparisonPair> iterator) {
            this.iterator = iterator;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ComparisonPair next() {
            ComparisonPair returnValue = this.next;
            this.next = this.findNext();
            return returnValue;
        }

        @Override
        public void remove() {
            throw new InternalError("not implemented");
        }

        private ComparisonPair findNext() {
            boolean nowFinding = true;
            while (nowFinding && this.iterator.hasNext()) {
                ComparisonPair nextPair = this.iterator.next();
                if (!this.isAllFilterPassed(nextPair)) continue;
                nowFinding = false;
                this.next = nextPair;
            }
            if (nowFinding && !this.iterator.hasNext()) {
                this.next = null;
            }
            return this.next;
        }

        private boolean isAllFilterPassed(ComparisonPair pair) {
            boolean flag = true;
            for (ComparisonPairFilterSet filter : FilteredComparisonResultSet.this.filters) {
                if (filter.isFiltered(pair)) continue;
                flag = false;
                break;
            }
            return flag;
        }
    }
}

