/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractionFailedException;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.birthmarks.PlainBirthmark;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public abstract class AbstractBirthmarkExtractor
implements BirthmarkExtractor {
    private BirthmarkSpi spi;

    public AbstractBirthmarkExtractor() {
    }

    public AbstractBirthmarkExtractor(BirthmarkSpi spi) {
        this.spi = spi;
    }

    public BirthmarkSpi getProvider() {
        return this.spi;
    }

    public final Birthmark extract(InputStream in) throws BirthmarkExtractionFailedException {
        return this.extract(in, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public final Birthmark extract(byte[] bytecode) throws BirthmarkExtractionFailedException {
        return this.extract(bytecode, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public final Birthmark extract(Birthmark birthmark, InputStream in) throws BirthmarkExtractionFailedException {
        return this.extract(birthmark, in, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public final Birthmark extract(Birthmark birthmark, byte[] bytecode) throws BirthmarkExtractionFailedException {
        return this.extract(birthmark, bytecode, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public final Birthmark extract(InputStream in, BirthmarkEnvironment environment) throws BirthmarkExtractionFailedException {
        return this.extract(this.createBirthmark(), in, environment);
    }

    public final Birthmark extract(Birthmark birthmark, byte[] bytecode, BirthmarkEnvironment environment) throws BirthmarkExtractionFailedException {
        return this.extract(birthmark, new ByteArrayInputStream(bytecode), environment);
    }

    public final Birthmark extract(byte[] bytecode, BirthmarkEnvironment environment) throws BirthmarkExtractionFailedException {
        return this.extract(this.createBirthmark(), new ByteArrayInputStream(bytecode), environment);
    }

    public abstract Birthmark extract(Birthmark var1, InputStream var2, BirthmarkEnvironment var3) throws BirthmarkExtractionFailedException;

    public Birthmark createBirthmark() {
        return new PlainBirthmark(this.getProvider().getType());
    }

    public abstract ExtractionUnit[] getAcceptableUnits();

    public boolean isAcceptable(ExtractionUnit unit) {
        ExtractionUnit[] units = this.getAcceptableUnits();
        for (int i = 0; i < units.length; ++i) {
            if (units[i] != unit) continue;
            return true;
        }
        return false;
    }
}

