/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.ApplicationInitializationError;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractionFailedException;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.event.BirthmarkEngineEvent;
import jp.naist.se.stigmata.event.BirthmarkEngineListener;
import jp.naist.se.stigmata.event.OperationStage;
import jp.naist.se.stigmata.event.OperationType;
import jp.naist.se.stigmata.event.WarningMessages;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.reader.DefaultClassFileArchive;
import jp.naist.se.stigmata.reader.JarClassFileArchive;
import jp.naist.se.stigmata.reader.WarClassFileArchive;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.utils.ConfigFileImporter;
import org.apache.commons.beanutils.BeanUtils;

public final class Stigmata {
    private static final Stigmata instance = new Stigmata();
    private BirthmarkEnvironment defaultEnvironment = BirthmarkEnvironment.getDefaultEnvironment();
    private boolean configDone = false;
    private Stack<WarningMessages> stack = new Stack();
    private WarningMessages warnings;
    private List<BirthmarkEngineListener> listeners = new ArrayList<BirthmarkEngineListener>();

    private Stigmata() {
    }

    public static Stigmata getInstance() {
        return instance;
    }

    public void addBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.remove(listener);
    }

    public WarningMessages getWarnings() {
        return this.warnings;
    }

    public void configuration() {
        this.operationStart(OperationType.CONFIGURATION);
        this.configuration(null);
        this.operationDone(OperationType.CONFIGURATION);
    }

    public void configuration(String filePath) {
        InputStream target = null;
        if (filePath != null) {
            try {
                target = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                filePath = null;
            }
        } else {
            File file = new File("stigmata.xml");
            if (!file.exists() && !(file = new File(System.getProperty("user.home"), ".stigmata.xml")).exists()) {
                file = null;
            }
            if (file != null) {
                try {
                    target = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                    throw new InternalError(ex.getMessage());
                }
            }
        }
        if (target == null) {
            target = this.getClass().getResourceAsStream("/resources/stigmata.xml");
        }
        this.initConfiguration(target);
    }

    public BirthmarkEnvironment createEnvironment() {
        this.operationStart(OperationType.CREATE_ENVIRONMENT);
        BirthmarkEnvironment environment = new BirthmarkEnvironment();
        this.operationDone(OperationType.CREATE_ENVIRONMENT);
        return environment;
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files) throws BirthmarkExtractionFailedException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        BirthmarkSet[] set = this.extract(birthmarks, files, this.createEnvironment());
        this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        return set;
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files, BirthmarkEnvironment environment) throws BirthmarkExtractionFailedException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        try {
            BirthmarkSet[] birthmarkSetArray = this.extractImpl(birthmarks, files, environment);
            return birthmarkSetArray;
        }
        catch (IOException e) {
            throw new BirthmarkExtractionFailedException(e);
        }
        finally {
            this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        }
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders) throws IOException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(holders, this.createEnvironment());
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders, BirthmarkEnvironment environment) throws IOException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders, environment, true);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return result;
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2) throws IOException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(holders1, holders2, this.createEnvironment());
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2, BirthmarkEnvironment environment) throws IOException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders1, holders2, environment);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return result;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, String[] filters) {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.filter(resultset, filters, this.createEnvironment());
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, String[] filters, BirthmarkEnvironment environment) {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        if (filters != null) {
            ArrayList<ComparisonPairFilterSet> filterList = new ArrayList<ComparisonPairFilterSet>();
            ComparisonPairFilterManager manager = environment.getFilterManager();
            for (int i = 0; i < filters.length; ++i) {
                ComparisonPairFilterSet fset = manager.getFilterSet(filters[i]);
                if (fset != null) {
                    filterList.add(fset);
                    continue;
                }
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.warning(filters[i] + ": filter not found");
            }
            return this.filter(resultset, filterList.toArray(new ComparisonPairFilterSet[filterList.size()]));
        }
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return resultset;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters) {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.filter(resultset, filters, this.createEnvironment());
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet filter(ComparisonResultSet resultset, ComparisonPairFilterSet[] filters, BirthmarkEnvironment environment) {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        FilteredComparisonResultSet filterResultSet = new FilteredComparisonResultSet(resultset);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return filterResultSet;
    }

    public double compareDetails(BirthmarkSet h1, BirthmarkSet h2) {
        this.operationStart(OperationType.COMPARE_DETAIL_BIRTHMARKS);
        double similarity = this.compareDetails(h1, h2, this.createEnvironment());
        this.operationDone(OperationType.COMPARE_DETAIL_BIRTHMARKS);
        return similarity;
    }

    public double compareDetails(BirthmarkSet h1, BirthmarkSet h2, BirthmarkEnvironment environment) {
        this.operationStart(OperationType.COMPARE_DETAIL_BIRTHMARKS);
        ComparisonPair pair = new ComparisonPair(h1, h2, environment);
        double sim = pair.calculateSimilarity();
        this.operationDone(OperationType.COMPARE_DETAIL_BIRTHMARKS);
        return sim;
    }

    private BirthmarkExtractor[] createExtractors(String[] birthmarkTypes, BirthmarkEnvironment environment) {
        ArrayList<BirthmarkExtractor> list = new ArrayList<BirthmarkExtractor>();
        for (String type : birthmarkTypes) {
            BirthmarkExtractor extractor = this.createExtractor(type, environment);
            list.add(extractor);
        }
        return list.toArray(new BirthmarkExtractor[list.size()]);
    }

    private BirthmarkExtractor createExtractor(String birthmarkType, BirthmarkEnvironment environment) {
        BirthmarkSpi spi = environment.getService(birthmarkType);
        if (spi != null) {
            BirthmarkExtractor extractor = spi.getExtractor();
            try {
                Map props = BeanUtils.describe((Object)extractor);
                props.remove("class");
                props.remove("provider");
                for (Object keyObject : props.keySet()) {
                    String key = "extractor." + spi.getType() + "." + String.valueOf(keyObject);
                    if (environment.getProperty(key) == null) continue;
                    BeanUtils.setProperty((Object)extractor, (String)((String)keyObject), (Object)environment.getProperty(key));
                }
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
            return extractor;
        }
        return null;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] dataBuffer = new byte[512];
        while ((read = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
            bout.write(dataBuffer, 0, read);
        }
        byte[] data = bout.toByteArray();
        bout.close();
        return data;
    }

    private void initConfiguration(InputStream in) {
        try {
            ConfigFileImporter parser = new ConfigFileImporter(this.defaultEnvironment);
            parser.parse(in);
        }
        catch (IOException e) {
            throw new ApplicationInitializationError(e);
        }
        Iterator<BirthmarkSpi> i = ServiceRegistry.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi service = i.next();
            this.defaultEnvironment.addService(service);
        }
        this.configDone = true;
    }

    private void operationStart(OperationType type) {
        if (type != OperationType.CONFIGURATION && !this.configDone) {
            this.configuration();
        }
        if (this.warnings == null) {
            this.warnings = new WarningMessages(type);
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_START, type, this.warnings));
        }
        this.stack.push(this.warnings);
        this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_START, type, this.warnings));
    }

    private void operationDone(OperationType type) {
        this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_DONE, type, this.warnings));
        this.stack.pop();
        if (this.stack.size() == 0) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_DONE, type, this.warnings));
            this.warnings = null;
        }
    }

    private void fireEvent(BirthmarkEngineEvent e) {
        block6: for (BirthmarkEngineListener listener : this.listeners) {
            switch (e.getStage()) {
                case OPERATION_START: {
                    listener.operationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_START: {
                    listener.subOperationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_DONE: {
                    listener.subOperationDone(e);
                    continue block6;
                }
                case OPERATION_DONE: {
                    listener.operationDone(e);
                    continue block6;
                }
            }
            throw new InternalError("unknown stage: " + (Object)((Object)e.getStage()));
        }
    }

    private BirthmarkSet[] extractImpl(String[] birthmarks, String[] files, BirthmarkEnvironment environment) throws IOException, BirthmarkExtractionFailedException {
        ClassFileArchive[] archives = this.createArchives(files, environment);
        BirthmarkExtractor[] extractors = this.createExtractors(birthmarks, environment);
        ExtractionUnit unit = environment.getExtractionUnit();
        if (unit == ExtractionUnit.PACKAGE) {
            return this.extractFromPackage(archives, extractors, environment);
        }
        if (unit == ExtractionUnit.ARCHIVE) {
            return this.extractFromProduct(archives, extractors, environment);
        }
        return this.extractFromClass(archives, extractors, environment);
    }

    private BirthmarkSet[] extractFromPackage(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment environment) throws IOException, BirthmarkExtractionFailedException {
        HashMap<String, BirthmarkSet> list = new HashMap<String, BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    String name = entry.getClassName();
                    String packageName = this.parsePackageName(name);
                    BirthmarkSet bs = (BirthmarkSet)list.get(packageName);
                    if (bs == null) {
                        bs = new BirthmarkSet(packageName, archive.getLocation());
                        list.put(packageName, bs);
                    }
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.PACKAGE)) continue;
                        Birthmark b = bs.getBirthmark(extractor.getProvider().getType());
                        if (b == null) {
                            b = extractor.createBirthmark();
                            bs.addBirthmark(b);
                        }
                        extractor.extract(b, new ByteArrayInputStream(data), environment);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, archive.getName());
                }
            }
        }
        return list.values().toArray(new BirthmarkSet[list.size()]);
    }

    private String parsePackageName(String name) {
        String n = name.replace('/', '.');
        int index = n.lastIndexOf(46);
        if (index > 0) {
            n = n.substring(0, index - 1);
        }
        return n;
    }

    private BirthmarkSet[] extractFromClass(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment environment) throws IOException, BirthmarkExtractionFailedException {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    BirthmarkSet birthmarkset = new BirthmarkSet(entry.getClassName(), entry.getLocation());
                    list.add(birthmarkset);
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.CLASS)) continue;
                        Birthmark b = extractor.extract(new ByteArrayInputStream(data), environment);
                        birthmarkset.addBirthmark(b);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    private BirthmarkSet[] extractFromProduct(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment environment) throws IOException, BirthmarkExtractionFailedException {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            BirthmarkSet birthmarkset = new BirthmarkSet(archive.getName(), archive.getLocation());
            list.add(birthmarkset);
            for (ClassFileEntry entry : archive) {
                try {
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.ARCHIVE)) continue;
                        Birthmark b = birthmarkset.getBirthmark(extractor.getProvider().getType());
                        if (b == null) {
                            b = extractor.createBirthmark();
                            birthmarkset.addBirthmark(b);
                        }
                        extractor.extract(b, new ByteArrayInputStream(data), environment);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            BirthmarkSet set = (BirthmarkSet)i.next();
            if (set.getBirthmarksCount() != 0) continue;
            i.remove();
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    private ClassFileArchive[] createArchives(String[] files, BirthmarkEnvironment environment) throws IOException, MalformedURLException {
        ClasspathContext bytecode = environment.getClasspathContext();
        ArrayList<ClassFileArchive> archives = new ArrayList<ClassFileArchive>();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i].endsWith(".class")) {
                    archives.add(new DefaultClassFileArchive(files[i]));
                    continue;
                }
                if (files[i].endsWith(".jar") || files[i].endsWith(".zip")) {
                    archives.add(new JarClassFileArchive(files[i]));
                    bytecode.addClasspath(new File(files[i]).toURI().toURL());
                    continue;
                }
                if (!files[i].endsWith(".war")) continue;
                archives.add(new WarClassFileArchive(files[i]));
                continue;
            }
            catch (IOException e) {
                this.warnings.addMessage(e, files[i]);
            }
        }
        return archives.toArray(new ClassFileArchive[archives.size()]);
    }
}

