/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonPairFilterSet
implements Iterable<ComparisonPairFilter> {
    private List<ComparisonPairFilter> filters = new ArrayList<ComparisonPairFilter>();
    private String name;
    private boolean matchall = true;

    public boolean isFiltered(ComparisonPair pair) {
        boolean flag;
        if (this.isMatchAll()) {
            flag = true;
            for (ComparisonPairFilter filter : this.filters) {
                if (filter.isFiltered(pair)) continue;
                flag = false;
                break;
            }
        } else {
            flag = false;
            for (ComparisonPairFilter filter : this.filters) {
                if (!filter.isFiltered(pair)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public boolean isMatchAll() {
        return this.matchall;
    }

    public boolean isMatchAny() {
        return !this.isMatchAll();
    }

    public void setMatchAll() {
        this.matchall = true;
    }

    public void setMatchAny() {
        this.matchall = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean addFilter(ComparisonPairFilter o) {
        return this.filters.add(o);
    }

    public void removeAllFilters() {
        this.filters.clear();
    }

    public ComparisonPairFilter getFilter(int index) {
        return this.filters.get(index);
    }

    @Override
    public Iterator<ComparisonPairFilter> iterator() {
        return this.filters.iterator();
    }

    public ComparisonPairFilter removeFilter(int index) {
        return this.filters.remove(index);
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("filterset{ ");
        sb.append("name=").append(this.getName()).append(", ");
        sb.append(this.isMatchAll() ? "match_all" : "match_any");
        sb.append(", ").append(this.filters).append("}");
        return new String(sb);
    }
}

