/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparisonFailedException;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractionFailedException;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ExtractionResult;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.ExtractorNotFoundException;
import jp.naist.se.stigmata.FilterNotFoundException;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.event.BirthmarkEngineEvent;
import jp.naist.se.stigmata.event.BirthmarkEngineListener;
import jp.naist.se.stigmata.event.OperationStage;
import jp.naist.se.stigmata.event.OperationType;
import jp.naist.se.stigmata.event.WarningMessages;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.reader.DefaultClassFileArchive;
import jp.naist.se.stigmata.reader.JarClassFileArchive;
import jp.naist.se.stigmata.reader.WarClassFileArchive;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkEngine {
    private BirthmarkEnvironment environment;
    private List<BirthmarkEngineListener> listeners = new ArrayList<BirthmarkEngineListener>();
    private Stack<WarningMessages> stack = new Stack();
    private WarningMessages warnings;
    private OperationType latestOperationType;
    private OperationType targetType;

    public BirthmarkEngine() {
        this(BirthmarkEnvironment.getDefaultEnvironment());
    }

    public BirthmarkEngine(BirthmarkEnvironment env) {
        this.environment = env;
    }

    public void addBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.remove(listener);
    }

    public ComparisonResultSet filter(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(target, context);
        crs = this.filter(crs, context);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet filter(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(targetX, targetY, context);
        crs = this.filter(crs, context);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet filter(ExtractionResult er, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        ComparisonResultSet crs = this.compare(er, context);
        crs = this.filter(crs, context);
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet filter(ComparisonResultSet crs, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.FILTER_BIRTHMARKS);
        String[] filterTypes = context.getFilterTypes();
        if (filterTypes != null) {
            ArrayList<ComparisonPairFilterSet> filterList = new ArrayList<ComparisonPairFilterSet>();
            ComparisonPairFilterManager manager = this.environment.getFilterManager();
            for (int i = 0; i < filterTypes.length; ++i) {
                ComparisonPairFilterSet fset = manager.getFilterSet(filterTypes[i]);
                if (fset != null) {
                    filterList.add(fset);
                    continue;
                }
                this.warnings.addMessage(new FilterNotFoundException("filter not found"), filterTypes[i]);
            }
            ComparisonPairFilterSet[] cpfs = filterList.toArray(new ComparisonPairFilterSet[filterList.size()]);
            crs = new FilteredComparisonResultSet(crs, cpfs);
        }
        this.operationDone(OperationType.FILTER_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet compare(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ExtractionResult er = this.extract(target, context);
        ComparisonResultSet crs = this.compare(er, context);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet compare(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ExtractionResult er = this.extract(targetX, targetY, context);
        ComparisonResultSet crs = this.compare(er, context);
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public ComparisonResultSet compare(ExtractionResult er, BirthmarkContext context) throws BirthmarkExtractionFailedException, BirthmarkComparisonFailedException {
        this.operationStart(OperationType.COMPARE_BIRTHMARKS);
        ComparisonResultSet crs = null;
        switch (context.getComparisonMethod()) {
            case ROUND_ROBIN: {
                crs = new RoundRobinComparisonResultSet(er.getBirthmarkSetXY(), this.environment, true);
                break;
            }
            case ROUND_ROBIN_XY: {
                crs = new RoundRobinComparisonResultSet(er.getBirthmarkSetX(), er.getBirthmarkSetY(), this.environment);
            }
            case GUESSED_PAIR: {
                crs = new CertainPairComparisonResultSet(er.getBirthmarkSetX(), er.getBirthmarkSetY(), this.environment);
                break;
            }
            case SPECIFIED_PAIR: {
                crs = new CertainPairComparisonResultSet(er.getBirthmarkSetX(), er.getBirthmarkSetY(), context.getNameMappings(), this.environment);
            }
        }
        this.operationDone(OperationType.COMPARE_BIRTHMARKS);
        return crs;
    }

    public ExtractionResult extract(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        ExtractionResult er = this.extract(target, null, context);
        this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        return er;
    }

    public ExtractionResult extract(String[] targetX, String[] targetY, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        this.operationStart(OperationType.EXTRACT_BIRTHMARKS);
        ExtractionResult er = new ExtractionResult();
        try {
            Object targetXY;
            switch (context.getComparisonMethod()) {
                case ROUND_ROBIN: {
                    targetXY = this.mergeTarget(targetX, targetY);
                    BirthmarkSet[] s = this.extractImpl((String[])targetXY, context);
                    er.setBirthmarkSetXY(s);
                    break;
                }
                default: {
                    if (targetX == null || targetY == null) {
                        throw new BirthmarkExtractionFailedException("targetX or targetY is null");
                    }
                    BirthmarkSet[] extractResultX = this.extractImpl(targetX, context);
                    BirthmarkSet[] extractResultY = this.extractImpl(targetY, context);
                    er.setBirthmarkSetX(extractResultX);
                    er.setBirthmarkSetY(extractResultY);
                }
            }
            targetXY = er;
            return targetXY;
        }
        catch (IOException e) {
            throw new BirthmarkExtractionFailedException(e);
        }
        finally {
            this.operationDone(OperationType.EXTRACT_BIRTHMARKS);
        }
    }

    private String[] mergeTarget(String[] t1, String[] t2) {
        ArrayList<String> list = new ArrayList<String>();
        this.addToList(list, t1);
        this.addToList(list, t2);
        return list.toArray(new String[list.size()]);
    }

    private void addToList(List<String> list, String[] target) {
        if (target != null) {
            for (String s : target) {
                list.add(s);
            }
        }
    }

    private BirthmarkSet[] extractImpl(String[] target, BirthmarkContext context) throws BirthmarkExtractionFailedException, IOException {
        ClassFileArchive[] archives = this.createArchives(target, this.environment);
        BirthmarkExtractor[] extractors = this.createExtractors(context.getExtractionTypes(), this.environment);
        ExtractionUnit unit = context.getExtractionUnit();
        BirthmarkSet[] extractResult = null;
        if (unit == ExtractionUnit.CLASS) {
            extractResult = this.extractFromClass(archives, extractors, this.environment);
        } else if (unit == ExtractionUnit.PACKAGE) {
            extractResult = this.extractFromPackage(archives, extractors, this.environment);
        } else if (unit == ExtractionUnit.ARCHIVE) {
            extractResult = this.extractFromProduct(archives, extractors, this.environment);
        }
        return extractResult;
    }

    private BirthmarkExtractor[] createExtractors(String[] birthmarkTypes, BirthmarkEnvironment environment) {
        ArrayList<BirthmarkExtractor> list = new ArrayList<BirthmarkExtractor>();
        for (String type : birthmarkTypes) {
            BirthmarkExtractor extractor = this.createExtractor(type, environment);
            list.add(extractor);
        }
        return list.toArray(new BirthmarkExtractor[list.size()]);
    }

    private BirthmarkExtractor createExtractor(String birthmarkType, BirthmarkEnvironment environment) {
        BirthmarkSpi spi = environment.getService(birthmarkType);
        BirthmarkExtractor extractor = null;
        if (spi != null) {
            extractor = spi.getExtractor();
            try {
                if (extractor != null) {
                    Map props = BeanUtils.describe((Object)extractor);
                    props.remove("class");
                    props.remove("provider");
                    for (Object keyObject : props.keySet()) {
                        String key = "extractor." + spi.getType() + "." + String.valueOf(keyObject);
                        if (environment.getProperty(key) == null) continue;
                        BeanUtils.setProperty((Object)extractor, (String)((String)keyObject), (Object)environment.getProperty(key));
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (extractor == null) {
            this.warnings.addMessage(new ExtractorNotFoundException("extractor not found"), birthmarkType);
        }
        return null;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] dataBuffer = new byte[512];
        while ((read = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
            bout.write(dataBuffer, 0, read);
        }
        byte[] data = bout.toByteArray();
        bout.close();
        return data;
    }

    private BirthmarkSet[] extractFromPackage(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment context) throws IOException, BirthmarkExtractionFailedException {
        HashMap<String, BirthmarkSet> list = new HashMap<String, BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    String name = entry.getClassName();
                    String packageName = this.parsePackageName(name);
                    BirthmarkSet bs = (BirthmarkSet)list.get(packageName);
                    if (bs == null) {
                        bs = new BirthmarkSet(packageName, archive.getLocation());
                        list.put(packageName, bs);
                    }
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.PACKAGE)) continue;
                        Birthmark b = bs.getBirthmark(extractor.getProvider().getType());
                        if (b == null) {
                            b = extractor.createBirthmark();
                            bs.addBirthmark(b);
                        }
                        extractor.extract(b, new ByteArrayInputStream(data), context);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, archive.getName());
                }
            }
        }
        return list.values().toArray(new BirthmarkSet[list.size()]);
    }

    private String parsePackageName(String name) {
        String n = name.replace('/', '.');
        int index = n.lastIndexOf(46);
        if (index > 0) {
            n = n.substring(0, index - 1);
        }
        return n;
    }

    private BirthmarkSet[] extractFromClass(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment context) throws IOException, BirthmarkExtractionFailedException {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            for (ClassFileEntry entry : archive) {
                try {
                    BirthmarkSet birthmarkset = new BirthmarkSet(entry.getClassName(), entry.getLocation());
                    list.add(birthmarkset);
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.CLASS)) continue;
                        Birthmark b = extractor.extract(new ByteArrayInputStream(data), context);
                        birthmarkset.addBirthmark(b);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    private BirthmarkSet[] extractFromProduct(ClassFileArchive[] archives, BirthmarkExtractor[] extractors, BirthmarkEnvironment context) throws IOException, BirthmarkExtractionFailedException {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            BirthmarkSet birthmarkset = new BirthmarkSet(archive.getName(), archive.getLocation());
            list.add(birthmarkset);
            for (ClassFileEntry entry : archive) {
                try {
                    byte[] data = this.inputStreamToByteArray(entry.getLocation().openStream());
                    for (BirthmarkExtractor extractor : extractors) {
                        if (!extractor.isAcceptable(ExtractionUnit.ARCHIVE)) continue;
                        Birthmark b = birthmarkset.getBirthmark(extractor.getProvider().getType());
                        if (b == null) {
                            b = extractor.createBirthmark();
                            birthmarkset.addBirthmark(b);
                        }
                        extractor.extract(b, new ByteArrayInputStream(data), context);
                    }
                }
                catch (IOException e) {
                    this.warnings.addMessage(e, entry.getClassName());
                }
            }
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            BirthmarkSet set = (BirthmarkSet)i.next();
            if (set.getBirthmarksCount() != 0) continue;
            i.remove();
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    private ClassFileArchive[] createArchives(String[] files, BirthmarkEnvironment environment) throws IOException, MalformedURLException {
        ClasspathContext bytecode = environment.getClasspathContext();
        ArrayList<ClassFileArchive> archives = new ArrayList<ClassFileArchive>();
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i].endsWith(".class")) {
                    archives.add(new DefaultClassFileArchive(files[i]));
                    continue;
                }
                if (files[i].endsWith(".jar") || files[i].endsWith(".zip")) {
                    archives.add(new JarClassFileArchive(files[i]));
                    bytecode.addClasspath(new File(files[i]).toURI().toURL());
                    continue;
                }
                if (!files[i].endsWith(".war")) continue;
                archives.add(new WarClassFileArchive(files[i]));
                continue;
            }
            catch (IOException e) {
                this.warnings.addMessage(e, files[i]);
            }
        }
        return archives.toArray(new ClassFileArchive[archives.size()]);
    }

    private void operationStart(OperationType type) {
        if (this.warnings == null) {
            this.warnings = new WarningMessages(type);
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_START, type, this.warnings));
            this.latestOperationType = type;
            this.targetType = type;
        }
        this.stack.push(this.warnings);
        if (this.latestOperationType != type) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_START, type, this.warnings));
            this.latestOperationType = type;
        }
    }

    private void operationDone(OperationType type) {
        if (this.latestOperationType != type && this.targetType != type) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.SUB_OPERATION_DONE, type, this.warnings));
            this.latestOperationType = type;
        }
        this.stack.pop();
        if (this.stack.size() == 0) {
            this.fireEvent(new BirthmarkEngineEvent(OperationStage.OPERATION_DONE, type, this.warnings));
            this.warnings = null;
            this.latestOperationType = null;
        }
    }

    private void fireEvent(BirthmarkEngineEvent e) {
        block6: for (BirthmarkEngineListener listener : this.listeners) {
            switch (e.getStage()) {
                case OPERATION_START: {
                    listener.operationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_START: {
                    listener.subOperationStart(e);
                    continue block6;
                }
                case SUB_OPERATION_DONE: {
                    listener.subOperationDone(e);
                    continue block6;
                }
                case OPERATION_DONE: {
                    listener.operationDone(e);
                    continue block6;
                }
            }
            throw new InternalError("unknown stage: " + (Object)((Object)e.getStage()));
        }
    }
}

