/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IDefinitionChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShortLongOption
implements Serializable,
Cloneable,
IDefinitionChoice {
    private String shortOption_;
    private String longOption_;

    public ShortLongOption() {
        this.shortOption_ = "";
        this.longOption_ = "";
    }

    public ShortLongOption(ShortLongOption source) {
        this.setup(source);
    }

    public ShortLongOption(RStack stack) {
        this.setup(stack);
    }

    public void setup(ShortLongOption source) {
        this.shortOption_ = source.shortOption_;
        this.longOption_ = source.longOption_;
    }

    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        try {
            this.shortOption_ = URelaxer.getElementPropertyAsStringByStack(stack, "short-option");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.longOption_ = URelaxer.getElementPropertyAsStringByStack(stack, "long-option");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new ShortLongOption(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        if (this.shortOption_ != null) {
            URelaxer.setElementPropertyByString(element, "short-option", this.shortOption_);
        }
        if (this.longOption_ != null) {
            URelaxer.setElementPropertyByString(element, "long-option", this.longOption_);
        }
    }

    public String getShortOption() {
        return this.shortOption_;
    }

    public void setShortOption(String shortOption) {
        this.shortOption_ = shortOption;
    }

    public String getLongOption() {
        return this.longOption_;
    }

    public void setLongOption(String longOption) {
        this.longOption_ = longOption;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        if (this.shortOption_ != null) {
            buffer.append("<short-option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getShortOption())));
            buffer.append("</short-option>");
        }
        if (this.longOption_ != null) {
            buffer.append("<long-option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getLongOption())));
            buffer.append("</long-option>");
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        if (this.shortOption_ != null) {
            buffer.write("<short-option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getShortOption())));
            buffer.write("</short-option>");
        }
        if (this.longOption_ != null) {
            buffer.write("<long-option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getLongOption())));
            buffer.write("</long-option>");
        }
    }

    public void makeTextElement(PrintWriter buffer) {
        if (this.shortOption_ != null) {
            buffer.print("<short-option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getShortOption())));
            buffer.print("</short-option>");
        }
        if (this.longOption_ != null) {
            buffer.print("<long-option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getLongOption())));
            buffer.print("</long-option>");
        }
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getShortOptionAsString() {
        return URelaxer.getString(this.getShortOption());
    }

    public String getLongOptionAsString() {
        return URelaxer.getString(this.getLongOption());
    }

    public void setShortOptionByString(String string) {
        this.setShortOption(string);
    }

    public void setLongOptionByString(String string) {
        this.setLongOption(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(RStack stack) {
        return ShortLongOption.isMatchHungry(stack.makeClone());
    }

    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack.makeClone();
        boolean $match$ = false;
        Element element = target.peekElement();
        Element child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "short-option")) {
            return false;
        }
        $match$ = true;
        child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer.isTargetElement(child, "long-option")) {
            return false;
        }
        $match$ = true;
        if ($match$) {
            stack.eat(target);
        }
        return $match$;
    }
}

