/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.Map;
import javax.swing.JPanel;
import jp.naist.se.stigmata.ui.swing.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityGraphPane
extends JPanel {
    private static final long serialVersionUID = 2314463453465L;
    private Map<Integer, Integer> distributions;
    private int totalCount = 0;
    private int maxFrequency = 0;

    public SimilarityGraphPane(Map<Integer, Integer> distributions) {
        this.setPreferredSize(new Dimension(300, 300));
        this.distributions = distributions;
        this.initialize();
    }

    @Override
    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        Dimension dd = this.getSize();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = new Dimension(dd);
        this.paintBorder(g);
        g.setColor(Color.red);
        d.width -= 20;
        d.height -= 20;
        double w = (double)d.width / 100.0;
        Integer val1 = this.distributions.get(new Integer(0));
        double x = 20.0;
        for (int i = 1; i <= 100; ++i) {
            Integer val2 = this.distributions.get(new Integer(i));
            if (val2 == null) {
                val2 = new Integer(0);
            }
            double hh1 = (double)val1.intValue() * ((double)d.height / (double)this.totalCount);
            double hh2 = (double)val2.intValue() * ((double)d.height / (double)this.totalCount);
            g.draw(new Line2D.Double(x, (double)d.height - hh1, x + w, (double)d.height - hh2));
            x += w;
            val1 = val2;
        }
    }

    private void initialize() {
        this.maxFrequency = 0;
        for (int i = 0; i <= 100; ++i) {
            Integer frequency = this.distributions.get(new Integer(i));
            if (frequency == null) {
                frequency = new Integer(0);
                this.distributions.put(new Integer(i), frequency);
            }
            if (this.maxFrequency < frequency) {
                this.maxFrequency = frequency;
            }
            this.totalCount += frequency.intValue();
        }
    }

    private void paintBorder(Graphics2D g) {
        Dimension d = this.getSize();
        g.setColor(Color.BLACK);
        g.draw(new Line2D.Double(0.0, d.height - 20, d.width, d.height - 20));
        g.draw(new Line2D.Double(20.0, 0.0, 20.0, d.height));
        g.setColor(Color.GRAY);
        double h = (d.height - 20) / 2;
        g.draw(new Line2D.Double(20.0, h, d.width, h));
        g.draw(new Line2D.Double(20.0, h /= 2.0, d.width, h));
        g.draw(new Line2D.Double(20.0, h * 3.0, d.width, h * 3.0));
        double w = ((double)d.width - 20.0) / 2.0;
        g.draw(new Line2D.Double(w + 20.0, 0.0, w + 20.0, d.height - 20));
        g.draw(new Line2D.Double((w /= 2.0) + 20.0, 0.0, w + 20.0, d.height - 20));
        g.draw(new Line2D.Double(w * 3.0 + 20.0, 0.0, w * 3.0 + 20.0, d.height - 20));
        g.drawString("0", 10, d.height - 5);
        g.drawString("50%", (d.width - 20) / 2 + 10, d.height - 5);
        g.drawString(Messages.getString("similarity.label"), d.width - 60, d.height - 5);
        g.drawString("50%", 0, (d.height - 20) / 2);
    }
}

