/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.reader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.reader.ClassFileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathContext
implements Iterable<URL> {
    private static ClasspathContext DEFAULT_CONTEXT = new ClasspathContext();
    private ClasspathContext parent;
    private List<URL> classpath = new ArrayList<URL>();
    private ClassLoader loader = null;

    private ClasspathContext() {
    }

    public ClasspathContext(ClasspathContext parent) {
        this.parent = parent;
    }

    public static final ClasspathContext getDefaultContext() {
        return DEFAULT_CONTEXT;
    }

    public synchronized void addClasspath(URL url) {
        this.classpath.add(url);
        this.loader = null;
    }

    public void clear() {
        this.classpath.clear();
    }

    @Override
    public Iterator<URL> iterator() {
        return this.classpath.iterator();
    }

    public Iterator<URL> classpath() {
        if (this.parent == null) {
            return this.iterator();
        }
        final Iterator<URL> parentIterator = this.parent.classpath();
        final Iterator<URL> thisIterator = this.iterator();
        return new Iterator<URL>(){

            @Override
            public boolean hasNext() {
                boolean next = parentIterator.hasNext();
                if (!next) {
                    next = thisIterator.hasNext();
                }
                return next;
            }

            @Override
            public URL next() {
                URL nextObject = null;
                nextObject = parentIterator.hasNext() ? (URL)parentIterator.next() : (URL)thisIterator.next();
                return nextObject;
            }

            @Override
            public void remove() {
            }
        };
    }

    public synchronized ClassLoader createClassLoader() {
        if (this.loader == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            Iterator<URL> i = this.classpath();
            while (i.hasNext()) {
                list.add(i.next());
            }
            this.loader = new URLClassLoader(list.toArray(new URL[list.size()]), this.getClass().getClassLoader());
        }
        return this.loader;
    }

    public ClassFileEntry find(String className) throws ClassNotFoundException {
        ClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource(className.replace('.', '/') + ".class");
        if (resource != null) {
            return new ClassFileEntry(className, resource);
        }
        return null;
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        ClassLoader loader = this.createClassLoader();
        return loader.loadClass(className);
    }
}

