/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ConfigFileParser;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.reader.ClassFileArchive;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.reader.DefaultClassFileArchive;
import jp.naist.se.stigmata.reader.JarClassFileArchive;
import jp.naist.se.stigmata.reader.WarClassFileArchive;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class Stigmata {
    private static final Stigmata instance = new Stigmata();
    private BirthmarkContext defaultContext = BirthmarkContext.getDefaultContext();
    private boolean configDone = false;

    private Stigmata() {
    }

    public static Stigmata getInstance() {
        return instance;
    }

    public void configuration() {
        this.configuration(null);
    }

    public void configuration(String filePath) {
        InputStream target = null;
        if (filePath == null) {
            File file = new File("birthmark.xml");
            if (!file.exists() && !(file = new File(System.getProperty("user.home"), ".birthmark.xml")).exists()) {
                file = null;
            }
            if (file != null) {
                try {
                    target = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                    throw new InternalError(ex.getMessage());
                }
            }
        }
        if (target == null) {
            target = this.getClass().getResourceAsStream("/resources/birthmark.xml");
        }
        this.initConfiguration(target);
    }

    public BirthmarkContext createContext() {
        if (!this.configDone) {
            this.configuration();
        }
        return new BirthmarkContext();
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.extract(birthmarks, files, this.createContext());
    }

    public BirthmarkSet[] extract(String[] birthmarks, String[] files, BirthmarkContext context) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        ArrayList<ClassFileArchive> archives = new ArrayList<ClassFileArchive>();
        ClasspathContext bytecode = context.getBytecodeContext();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].endsWith(".class")) {
                archives.add(new DefaultClassFileArchive(files[i]));
                continue;
            }
            if (files[i].endsWith(".jar") || files[i].endsWith(".zip")) {
                archives.add(new JarClassFileArchive(files[i]));
                bytecode.addClasspath(new File(files[i]).toURI().toURL());
                continue;
            }
            if (!files[i].endsWith(".war")) continue;
            archives.add(new WarClassFileArchive(files[i]));
        }
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        for (ClassFileArchive archive : archives) {
            Iterator<ClassFileEntry> entries = archive.entries();
            while (entries.hasNext()) {
                ClassFileEntry entry = entries.next();
                BirthmarkSet holder = new BirthmarkSet(entry.getClassName(), entry.getLocation());
                this.extractBirthmark(birthmarks, holder.getLocation().openStream(), holder, context);
                list.add(holder);
            }
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(holders, this.createContext());
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders, BirthmarkContext context) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders, context, true);
        return result;
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(holders1, holders2, this.createContext());
    }

    public ComparisonResultSet compare(BirthmarkSet[] holders1, BirthmarkSet[] holders2, BirthmarkContext context) throws IOException {
        if (!this.configDone) {
            this.configuration();
        }
        RoundRobinComparisonResultSet result = new RoundRobinComparisonResultSet(holders1, holders2, context);
        return result;
    }

    public double compare(BirthmarkSet h1, BirthmarkSet h2) {
        if (!this.configDone) {
            this.configuration();
        }
        return this.compare(h1, h2, this.createContext());
    }

    public double compare(BirthmarkSet h1, BirthmarkSet h2, BirthmarkContext context) {
        if (!this.configDone) {
            this.configuration();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        int count = 0;
        Iterator<String> i = h1.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark b1 = h1.getBirthmark(type);
            Birthmark b2 = h2.getBirthmark(type);
            double similarity = Double.NaN;
            if (b1 != null && b2 != null) {
                BirthmarkSpi spi = context.getService(type);
                BirthmarkComparator comparator = spi.getComparator();
                similarity = comparator.compare(b1, b2);
                ++count;
            }
            list.add(similarity);
        }
        double similarity = 0.0;
        for (Double d : list) {
            if (d == Double.NaN) continue;
            similarity += d.doubleValue();
        }
        return similarity / (double)count;
    }

    private BirthmarkSet extractBirthmark(String[] birthmarks, InputStream in, BirthmarkSet holder, BirthmarkContext context) throws IOException {
        byte[] data = this.inputStreamToByteArray(in);
        return this.extractBirthmark(birthmarks, data, holder, context);
    }

    private BirthmarkSet extractBirthmark(String[] birthmarks, byte[] bytecode, BirthmarkSet holder, BirthmarkContext context) throws IOException {
        for (String birthmark : birthmarks) {
            BirthmarkSpi spi = context.getService(birthmark);
            if (spi == null) continue;
            BirthmarkExtractor extractor = spi.getExtractor();
            holder.addBirthmark(extractor.extract(new ByteArrayInputStream(bytecode), context));
        }
        return holder;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] dataBuffer = new byte[512];
        while ((read = in.read(dataBuffer, 0, dataBuffer.length)) != -1) {
            bout.write(dataBuffer, 0, read);
        }
        byte[] data = bout.toByteArray();
        bout.close();
        return data;
    }

    private void initConfiguration(InputStream in) {
        try {
            ConfigFileParser parser = new ConfigFileParser(this.defaultContext);
            parser.parse(in);
        }
        catch (IOException e) {
            return;
        }
        Iterator<BirthmarkSpi> i = ServiceRegistry.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi service = i.next();
            this.defaultContext.addService(service);
        }
        this.configDone = true;
    }
}

