/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List currentClassInterfaces;
    private final boolean isInterface;

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type currentClass, Type currentSuperClass, boolean isInterface) {
        this(currentClass, currentSuperClass, null, isInterface);
    }

    public SimpleVerifier(Type currentClass, Type currentSuperClass, List currentClassInterfaces, boolean isInterface) {
        this.currentClass = currentClass;
        this.currentSuperClass = currentSuperClass;
        this.currentClassInterfaces = currentClassInterfaces;
        this.isInterface = isInterface;
    }

    public Value newValue(Type type) {
        Value v = super.newValue(type);
        if (v == BasicValue.REFERENCE_VALUE) {
            v = new BasicValue(type);
        }
        return v;
    }

    protected boolean isArrayValue(Value value) {
        Type t = ((BasicValue)value).getType();
        if (t != null) {
            return t.getDescriptor().equals("Lnull;") || t.getSort() == 9;
        }
        return false;
    }

    protected Value getElementValue(Value objectArrayValue) throws AnalyzerException {
        Type arrayType = ((BasicValue)objectArrayValue).getType();
        if (arrayType != null) {
            if (arrayType.getSort() == 9) {
                return this.newValue(Type.getType(arrayType.getDescriptor().substring(1)));
            }
            if (arrayType.getDescriptor().equals("Lnull;")) {
                return objectArrayValue;
            }
        }
        throw new AnalyzerException("Not an array type");
    }

    protected boolean isSubTypeOf(Value value, Value expected) {
        Type expectedType = ((BasicValue)expected).getType();
        Type type = ((BasicValue)value).getType();
        if (expectedType == null) {
            return type == null;
        }
        switch (expectedType.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type == expectedType;
            }
            case 9: 
            case 10: {
                if (expectedType.getDescriptor().equals("Lnull;")) {
                    return type.getSort() == 10 || type.getSort() == 9;
                }
                if (type.getDescriptor().equals("Lnull;")) {
                    return true;
                }
                if (type.getSort() == 10 || type.getSort() == 9) {
                    return this.isAssignableFrom(expectedType, type);
                }
                return false;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Value merge(Value v, Value w) {
        if (!v.equals(w)) {
            Type t = ((BasicValue)v).getType();
            Type u = ((BasicValue)w).getType();
            if (!(t == null || t.getSort() != 10 && t.getSort() != 9 || u == null || u.getSort() != 10 && u.getSort() != 9)) {
                if (t.getDescriptor().equals("Lnull;")) {
                    return w;
                }
                if (u.getDescriptor().equals("Lnull;")) {
                    return v;
                }
                if (this.isAssignableFrom(t, u)) {
                    return v;
                }
                if (this.isAssignableFrom(u, t)) {
                    return w;
                }
                do {
                    if (t != null && !this.isInterface(t)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(t = this.getSuperClass(t), u));
                return this.newValue(t);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }

    private boolean isInterface(Type t) {
        if (this.currentClass != null && t.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(t).isInterface();
    }

    private Type getSuperClass(Type t) {
        if (this.currentClass != null && t.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class c = this.getClass(t).getSuperclass();
        return c == null ? null : Type.getType(c);
    }

    private boolean isAssignableFrom(Type t, Type u) {
        if (t.equals(u)) {
            return true;
        }
        if (this.currentClass != null && t.equals(this.currentClass)) {
            return this.isAssignableFrom(t, this.getSuperClass(u));
        }
        if (this.currentClass != null && u.equals(this.currentClass)) {
            if (this.isAssignableFrom(t, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type v = (Type)this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(t, v)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.getClass(t).isAssignableFrom(this.getClass(u));
    }

    protected Class getClass(Type t) {
        try {
            if (t.getSort() == 9) {
                return Class.forName(t.getDescriptor().replace('/', '.'));
            }
            return Class.forName(t.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

