/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.is;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.utils.WellknownClassManager;
import org.objectweb.asm.ClassVisitor;

public class InheritanceStructureBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    private Birthmark birthmark;

    public InheritanceStructureBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, context);
        this.birthmark = birthmark;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        try {
            Class<?> c = this.getContext().getBytecodeContext().findClass(name.replace('/', '.'));
            if (c != null && !c.isInterface()) {
                this.addISBirthmark(c);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private void addISBirthmark(Class c) {
        WellknownClassManager wcm = this.getContext().getWellknownClassManager();
        do {
            String className;
            if (wcm.isWellKnownClass(className = c.getName())) {
                this.birthmark.addElement(new BirthmarkElement(className));
                continue;
            }
            this.birthmark.addElement(BirthmarkElement.NULL);
        } while (!(c = c.getSuperclass()).getName().equals("java.lang.Object"));
        this.birthmark.addElement(new BirthmarkElement("java.lang.Object"));
    }
}

