/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.Edge;
import org.objectweb.asm.MethodWriter;

public class Label {
    int line;
    boolean resolved;
    int position;
    boolean resized;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int beginStackSize;
    int maxStackSize;
    Edge successors;
    Label next;
    boolean pushed;

    public int getOffset() {
        if (!this.resolved) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    void put(MethodWriter owner, ByteVector out, int source, boolean wideOffset) {
        if (this.resolved) {
            if (wideOffset) {
                out.putInt(this.position - source);
            } else {
                out.putShort(this.position - source);
            }
        } else if (wideOffset) {
            this.addReference(-1 - source, out.length);
            out.putInt(-1);
        } else {
            this.addReference(source, out.length);
            out.putShort(-1);
        }
    }

    private void addReference(int sourcePosition, int referencePosition) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] a = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, a, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = a;
        }
        this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
        this.srcAndRefPositions[this.referenceCount++] = referencePosition;
    }

    boolean resolve(MethodWriter owner, int position, byte[] data) {
        boolean needUpdate = false;
        this.resolved = true;
        this.position = position;
        int i = 0;
        while (i < this.referenceCount) {
            int offset;
            int source = this.srcAndRefPositions[i++];
            int reference = this.srcAndRefPositions[i++];
            if (source >= 0) {
                offset = position - source;
                if (offset < Short.MIN_VALUE || offset > Short.MAX_VALUE) {
                    int opcode = data[reference - 1] & 0xFF;
                    data[reference - 1] = opcode <= 168 ? (byte)(opcode + 49) : (byte)(opcode + 20);
                    needUpdate = true;
                }
                data[reference++] = (byte)(offset >>> 8);
                data[reference] = (byte)offset;
                continue;
            }
            offset = position + source + 1;
            data[reference++] = (byte)(offset >>> 24);
            data[reference++] = (byte)(offset >>> 16);
            data[reference++] = (byte)(offset >>> 8);
            data[reference] = (byte)offset;
        }
        return needUpdate;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

