/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands.exception;

import org.apache.commons.lang.StringUtils;

import net.murakamin.sticker.commands.ExecutableCommand;

/**
 * Exception when command is executed
 * 
 * @author Y.Murakamin
 */
public class CommandExecutionException extends Exception
{

	private static final long serialVersionUID = 2320501039299916888L;
	transient private ExecutableCommand target;
	private Object appendInfo;

	/**
	 * constractor
	 */
	public CommandExecutionException()
	{
		super();
	}

	/**
	 * constractor
	 * 
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final ExecutableCommand cause)
	{
		this();
		this.target = cause;
	}

	/**
	 * 
	 * constractor
	 * 
	 * @param causeCommand
	 *            Command object where exception is generated
	 * @param appendInfo
	 *            Addition information
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final ExecutableCommand causeCommand,
	        final Object appendInfo, final Throwable cause)
	{
		this(causeCommand, cause);
		this.appendInfo = appendInfo;
	}

	/**
	 * constractor
	 * 
	 * @param cause
	 *            Command object where exception is generated
	 * @param message
	 *            excepton message
	 */
	public CommandExecutionException(final ExecutableCommand cause,
	        final String message)
	{
		this(message);
		this.target = cause;
	}

	/**
	 * 
	 * constractor
	 * 
	 * @param causeCommand
	 *            Command object where exception is generated
	 * @param message
	 *            Exception message
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final ExecutableCommand causeCommand,
	        final String message, final Throwable cause)
	{
		this(message, cause);
		this.target = causeCommand;
	}

	/**
	 * constractor
	 * 
	 * @param causeCommand
	 *            Command object where exception is generated
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final ExecutableCommand causeCommand,
	        final Throwable cause)
	{
		this(cause);
		this.target = causeCommand;
	}

	/**
	 * constractor
	 * 
	 * @param message
	 *            Exception message
	 */
	public CommandExecutionException(final String message)
	{
		super(message);
	}

	/**
	 * constractor
	 * 
	 * @param message
	 *            exception message
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final String message, final Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * constractor
	 * 
	 * @param cause
	 *            cause object
	 */
	public CommandExecutionException(final Throwable cause)
	{
		super(cause);
	}

	/**
	 * get the Append information
	 * 
	 * @return append information string
	 */
	public String getAppendInfo()
	{
		return (this.appendInfo == null) ? StringUtils.EMPTY : this.appendInfo
		        .toString();
	}

	/**
	 * get the cause command object
	 * 
	 * @return cause command object
	 */
	public ExecutableCommand getCauseCommand()
	{
		return this.target;
	}
}
