/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;

import org.apache.commons.lang.SystemUtils;

/**
 * 
 * The connection information to connect it with the database server remotely is
 * defined. The connection information is uniquely identified applying the name.
 * 
 * @author Y.Murakamin
 * 
 */
public class ServerCommand implements Command, DatabaseConnectionProperties
{
	/**
	 * Database connection properties object key in StickerContext.
	 */
	public static final String CONTEXT_REMOTE_CONNECTION_PROP = "CONTEXT_REMOTE_CONNECTION_PROP";

	
	private boolean autoCommit = true;
	private String charset;
	private String driver;
	private String driverJarFileName;
	private String name;
	private String pass;
	private String url;
	private String user;

	/**
	 * 
	 * It connects it with the data base.
	 * 
	 * @param runner
	 *            {@link net.murakamin.sticker.CommandRunner} object
	 */
	public void execute(final CommandRunner runner) throws Exception
	{

//		try
//		{
			runner.getStickerContext().put(ServerCommand.CONTEXT_REMOTE_CONNECTION_PROP, this);
//
//			
//			
//			Connection con = this.createConnection(runner.getStickerContext(),
//			        this);
//			con.setAutoCommit(this.isAutoCommit());
//
//			runner.getConnectionPool().setRemoteConnection(this.getName(), con);
			runner.run(this);
//		} catch (Exception e)
//		{
//			throw new CommandExecutionException(this, e);
//		}
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getCharset()
	 */
	public String getCharset()
	{
		return charset;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getDriver()
	 */
	public String getDriver()
	{
		return driver;
	}

	/**
	 * get the driver jar file path
	 * 
	 * @return driver jar file path
	 */
	public String getDriverJarFile()
	{
		return this.driverJarFileName;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getName()
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getPass()
	 */
	public String getPass()
	{
		return pass;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getUrl()
	 */
	public String getUrl()
	{
		return url;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getUser()
	 */
	public String getUser()
	{
		return user;
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#getVersionTerm()
	 */
	public VersionTerm getVersionTerm()
	{
		return VersionTerm.PERMANENT_COMMAND;
	}

	/**
	 * @see net.murakamin.sticker.commands.DatabaseConnectionProperties#getAutocommit()
	 */
	public boolean getAutocommit()
	{
		return autoCommit;
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#isDebugPrint()
	 */
	public boolean isDebugPrint()
	{
		return true;
	}

	/**
	 * set the auto commit flag
	 * 
	 * @param autoCommit
	 *            true is auto commit
	 */
	public void setAutocommit(final boolean autoCommit)
	{
		this.autoCommit = autoCommit;
	}

	/**
	 * set the charcter set name
	 * 
	 * @param charset
	 *            the charcter set name
	 */
	public void setCharset(final String charset)
	{
		this.charset = charset;
	}

	/**
	 * set driver url
	 * 
	 * @param driver
	 *            driver name string
	 */
	public void setDriver(final String driver)
	{
		this.driver = driver;
	}

	/**
	 * set the driver jar file path
	 * 
	 * @param name
	 *            the driver jar file path
	 */
	public void setDriverJarFile(final String name)
	{
		this.driverJarFileName = name;

	}

	/**
	 * set the connection name
	 * 
	 * @param name
	 *            the connection name
	 */
	public void setName(final String name)
	{
		this.name = name;
	}

	/**
	 * set the database password
	 * 
	 * @param pass
	 *            the database password
	 */
	public void setPass(final String pass)
	{
		this.pass = pass;
	}

	/**
	 * set the database driver url
	 * 
	 * @param url
	 *            the database driver url
	 */
	public void setUrl(final String url)
	{
		this.url = url;
	}

	/**
	 * set the database connection user
	 * 
	 * @param user
	 *            the database connection user
	 */
	public void setUser(final String user)
	{
		this.user = user;
	}

	@Override
	public String toString()
	{

		StringBuffer buffer = new StringBuffer();

		buffer.append("<server> create connection:");
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" name:");
		buffer.append(this.getName());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" driver:");
		buffer.append(this.getDriver());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" url:");
		buffer.append(this.getUrl());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" user:");
		buffer.append(this.getUser());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" pass:");
		buffer.append(this.getPass());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" charset:");
		buffer.append(this.getCharset());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" autocommit:");
		buffer.append(this.getAutocommit());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		return buffer.toString();
	}
}
