/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package net.murakamin.sticker;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * Context object shared between each command while executing Sticker
 * 
 * @author Y.Murakamin
 */
public interface StickerContext extends Map<String, Object>
{
	/**
	 * If the value of the key specified by the argument exists, true is
	 * returned.
	 * 
	 * @param key
	 *            key
	 * @return If the value of the key specified by the argument exists, true is
	 *         returned.
	 */
	boolean containsKey(final Object key);

	/**
	 * If the value specified by the argument exists, true is returned.
	 * 
	 * @param value
	 *            target value
	 * @return If the value specified by the argument exists, true is returned.
	 */
	boolean containsValue(final Object value);

	/**
	 * The set view of this context is returned.
	 * 
	 * @return The set view of this Context.
	 */
	Set<Entry<String, Object>> entrySet();

	/**
	 * The value of the key specified by the argument is returned.
	 * 
	 * @param key
	 *            key
	 * @return The value of the key specified by the argument
	 */
	Object get(final Object key);

	/**
	 * When this context is empty, true is returned.
	 * 
	 * @return When this context is empty, true is returned.
	 */
	boolean isEmpty();

	/**
	 * The set view of the key to this context is returned.
	 * 
	 * @return The set view of the key to this context
	 */
	Set<String> keySet();

	public Map<String, Object> peekFieldStack();

	public Map<String, Object> popFieldStack();

	void pushFieldStack(final Map<String, Object> fieldMap);

	/**
	 * The value is set to this context.
	 * 
	 * @param key
	 *            key
	 * @param value
	 *            value object
	 * @return Object originally set to key specified by argument
	 */
	Object put(final String key, final Object value);

	/**
	 * The key specified by the argument is deleted.
	 * 
	 * @param key
	 *            key
	 * @return Object that relates to deleted key
	 */
	Object remove(final Object key);

	/**
	 * The size of this context is returned.
	 * 
	 * @return The size of this context
	 */
	int size();

	/**
	 * The list that stores the value stored in this context is returned.
	 * 
	 * @return The list that stores the value stored in this context.
	 */
	Collection<Object> values();

}