/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCSVReflectionException;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.io.ICsvBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.MethodCache;
import org.supercsv.util.Util;

public class CsvBeanWriter
extends AbstractCsvWriter
implements ICsvBeanWriter {
    protected List<? super Object> result;
    protected MethodCache cache = new MethodCache();

    public CsvBeanWriter(Writer writer, CsvPreference csvPreference) {
        super(writer, csvPreference);
        this.result = new ArrayList<Object>();
    }

    protected void fillListFromObject(Object object, String[] stringArray) throws SuperCSVReflectionException {
        try {
            this.result.clear();
            for (String string : stringArray) {
                this.result.add(this.cache.getGetMethod(object, string).invoke(object, new Object[0]));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SuperCSVReflectionException("Error accessing object " + object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SuperCSVReflectionException("Error accessing object " + object, invocationTargetException);
        }
    }

    public void write(Object object, String ... stringArray) throws IOException, SuperCSVReflectionException {
        this.fillListFromObject(object, stringArray);
        super.write(this.result);
    }

    public void write(Object object, String[] stringArray, CellProcessor[] cellProcessorArray) throws IOException, SuperCSVReflectionException {
        this.fillListFromObject(object, stringArray);
        ArrayList arrayList = new ArrayList();
        Util.processStringList(arrayList, this.result, cellProcessorArray, super.getLineNumber());
        super.write(arrayList);
    }
}

