/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseDouble
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseDouble() {
    }

    public ParseDouble(DoubleCellProcessor doubleCellProcessor) {
        super(doubleCellProcessor);
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        Double d;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof String) {
            try {
                d = new Double((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SuperCSVException("Parser error", cSVContext, this, numberFormatException);
            }
        } else {
            throw new SuperCSVException("Can't convert \"" + object + "\" to double. Input is not of type Double nor type String, but of type " + object.getClass().getName(), cSVContext, this);
        }
        return this.next.execute(d, cSVContext);
    }
}

