/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseDate
extends CellProcessorAdaptor
implements StringCellProcessor {
    protected final DateFormat formatter;

    public ParseDate(String string) {
        this.formatter = new SimpleDateFormat(string);
        this.formatter.setLenient(false);
    }

    public ParseDate(String string, DateCellProcessor dateCellProcessor) {
        super(dateCellProcessor);
        this.formatter = new SimpleDateFormat(string);
        this.formatter.setLenient(false);
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        try {
            Date date = this.formatter.parse((String)object);
            return this.next.execute(date, cSVContext);
        }
        catch (ParseException parseException) {
            throw new SuperCSVException("Problems parsing '" + object + "' as a date", cSVContext, this, parseException);
        }
    }
}

