/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseBigDecimal
extends CellProcessorAdaptor
implements StringCellProcessor {
    private DecimalFormatSymbols symbols;

    public ParseBigDecimal() {
        this((DecimalFormatSymbols)null);
    }

    public ParseBigDecimal(DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = decimalFormatSymbols;
    }

    public ParseBigDecimal(CellProcessor cellProcessor) {
        this(null, cellProcessor);
    }

    public ParseBigDecimal(DecimalFormatSymbols decimalFormatSymbols, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.symbols = decimalFormatSymbols;
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        BigDecimal bigDecimal;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof String) {
            try {
                if (this.symbols == null) {
                    bigDecimal = new BigDecimal((String)object);
                }
                if (this.symbols.getDecimalSeparator() != '.') {
                    String string = (String)object;
                    bigDecimal = new BigDecimal(string.replace(this.symbols.getDecimalSeparator(), '.'));
                }
                bigDecimal = new BigDecimal((String)object);
            }
            catch (Exception exception) {
                throw new SuperCSVException("Parser error", cSVContext, this, exception);
            }
        } else {
            throw new SuperCSVException("Can't convert \"" + object + "\" to a BigDecimal. Input is not of type String, but of type " + object.getClass().getName(), cSVContext, this);
        }
        return this.next.execute(bigDecimal, cSVContext);
    }
}

