/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Arrays;
import net.murakamin.csv.CSVParser;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.Messages;
import net.murakamin.sticker.commands.StickerCSVDataHandler;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CSVContext;

public class ExportCommand
implements Command,
StickerCSVDataHandler {
    private final Log log = LogFactory.getLog(Command.class);
    private ConnectionPool conPool;
    private String destination;
    private String fileCharset = SystemUtils.FILE_ENCODING;
    private boolean header = true;
    private boolean overwrite = true;
    private char quote = '\u0000';
    private boolean forceQuote = false;
    private char separator = (char)44;
    private String sql = "";
    private TargetType target = TargetType.remote;
    private CsvListWriter writer;
    private StickerContext context;
    private CellProcessor stringCellProcesser;

    /*
     * Unable to fully structure code
     */
    @Override
    public void addCSVData(String[] currentDatas) throws Exception {
        block15: {
            destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
            if (!this.conPool.existsLocalTable(destination)) {
                cellProcessers = new CellProcessor[currentDatas.length];
                c = 0;
                while (c < currentDatas.length) {
                    if (currentDatas[c] == null) {
                        currentDatas[c] = "";
                    }
                    currentDatas[c] = currentDatas[c].replaceAll("(\r\n)|(\r)", "\n");
                    cellProcessers[c] = this.stringCellProcesser;
                    ++c;
                }
                this.writer.write(Arrays.asList(currentDatas), cellProcessers);
            } else {
                sql = this.createInsertPrepareStatement(destination, currentDatas);
                if ((sql = sql.replaceAll("\t", " ")).charAt(sql.length() - 1) == ';') {
                    sql = sql.substring(0, sql.length() - 1);
                }
                destConnection = this.conPool.getLocalConnection();
                stmt = destConnection.prepareStatement(sql);
                parameterIndex = 1;
                var10_9 = currentDatas;
                var9_12 = currentDatas.length;
                var8_14 = 0;
                while (var8_14 < var9_12) {
                    field = var10_9[var8_14];
                    stmt.setObject(parameterIndex, field);
                    ++parameterIndex;
                    ++var8_14;
                }
                if (Sticker.isDebug()) {
                    buffer = new StringBuffer();
                    var11_19 = currentDatas;
                    var10_10 = currentDatas.length;
                    var9_12 = 0;
                    while (var9_12 < var10_10) {
                        param = var11_19[var9_12];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var9_12;
                    }
                    this.log.debug((Object)(stmt + ": parameters=" + buffer.toString()));
                }
                try {
                    try {
                        stmt.execute();
                        break block15;
                    }
                    catch (Exception e) {
                        buffer = new StringBuffer();
                        var12_21 = currentDatas;
                        var11_20 = currentDatas.length;
                        var10_11 = 0;
                        ** while (var10_11 < var11_20)
                    }
lbl-1000:
                    // 1 sources

                    {
                        param = var12_21[var10_11];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var10_11;
                        continue;
                    }
lbl65:
                    // 1 sources

                    this.log.error((Object)buffer.toString());
                    throw e;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    @Override
    public void execute(CommandRunner runner) throws Exception {
        this.conPool = runner.getConnectionPool();
        this.context = runner.getStickerContext();
        if (StringUtils.isEmpty((String)this.getSql().trim())) {
            throw new CommandExecutionException((ExecutableCommand)this, "SQL of the export is not defined.");
        }
        if (this.forceQuote && this.quote == '\u0000') {
            throw new CommandExecutionException((ExecutableCommand)this, Messages.getString("net.murakamin.sticker.commands.ExportCommand.invalidForceQuote"));
        }
        this.stringCellProcesser = this.forceQuote ? new StringCellProcessor(){

            public Object execute(Object arg0, CSVContext arg1) {
                String quoteRegex = new StringBuffer("(").append(ExportCommand.this.quote).append(")").toString();
                String quoteReplacement = new StringBuffer().append(ExportCommand.this.quote).append(ExportCommand.this.quote).toString();
                String target = (String)arg0;
                if (ExportCommand.this.forceQuote) {
                    target = target.replaceAll(quoteRegex, quoteReplacement);
                }
                return new StringBuffer(target).insert(0, ExportCommand.this.quote).append(ExportCommand.this.quote).toString();
            }
        } : new StringCellProcessor(){

            public Object execute(Object arg0, CSVContext arg1) {
                return (String)arg0;
            }
        };
        ResultSet rs = null;
        Statement stmt = null;
        Connection sourceConnection = this.conPool.getRemoteConnection();
        try {
            try {
                if (this.target == TargetType.local) {
                    sourceConnection = this.conPool.getLocalConnection();
                }
                String sql = StickerContextUtil.applyContextVariable(this.context, this.getSql());
                String executableSql = StickerContextUtil.getReplacementString(this.context, sql);
                String destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
                stmt = sourceConnection.prepareStatement(executableSql);
                rs = stmt.executeQuery();
                if (!this.conPool.existsLocalTable(destination)) {
                    CsvPreference pref = new CsvPreference(this.forceQuote ? (char)'\u0000' : this.getQuote(), (int)this.getSeparator(), "\n");
                    File destFile = new File(destination);
                    this.writer = new CsvListWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(destFile, !this.isOverwrite()), this.getFileCharset()), pref);
                    if (this.isHeader()) {
                        ResultSetMetaData rsMetaData = rs.getMetaData();
                        String[] header = new String[rsMetaData.getColumnCount()];
                        int c = 1;
                        while (c < rsMetaData.getColumnCount() + 1) {
                            header[c - 1] = rsMetaData.getColumnName(c);
                            ++c;
                        }
                        if (this.isOverwrite() || !new File(this.destination).exists()) {
                            this.writer.writeHeader(header);
                        }
                    }
                }
                new CSVParser(this).doParse(rs);
                runner.run(this);
            }
            catch (Exception e) {
                throw new CommandExecutionException((ExecutableCommand)this, (Throwable)e);
            }
        }
        finally {
            String destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
            if (!this.conPool.existsLocalTable(destination) && this.writer != null) {
                this.writer.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public String getFileCharset() {
        return this.fileCharset;
    }

    @Override
    public char getQuote() {
        return this.quote;
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuot) {
        this.forceQuote = forceQuot;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public String getTarget() {
        return this.target.name();
    }

    @Override
    public VersionTerm getVersionTerm() {
        return VersionTerm.PERMANENT_COMMAND;
    }

    @Override
    public boolean isDebugPrint() {
        return true;
    }

    @Override
    public boolean isHeader() {
        return this.header;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setFileCharset(String fileCharset) {
        this.fileCharset = fileCharset;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuote(char quot) {
        this.quote = quot;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<export> export execute:\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" header:");
        buffer.append(this.isHeader());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" separator:");
        buffer.append(this.getSeparator());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" quote:");
        buffer.append(this.getQuote() == '\u0000' ? "None" : Character.valueOf(this.getQuote()));
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" charset:");
        buffer.append(this.getFileCharset());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" sql:");
        buffer.append(this.getSql());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }
}

