/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.StickerContext;

import org.apache.commons.lang.SystemUtils;

/**
 * 
 * 
 * @author Y.Murakamin
 * 
 */
public class VariableCommand implements Command
{
	public static final String CONTEXT_VARIABLE_PREFIX = "CONTEXT_VARIANT_VALUE:";
	private String name;

	private String value;

	public void execute(final CommandRunner runner) throws Exception
	{
		StickerContext context = runner.getStickerContext();

		context.put(VariableCommand.CONTEXT_VARIABLE_PREFIX + this.getName(),
		        this.getValue());

		runner.run(this);
	}

	/**
	 * get the variant name
	 * 
	 * @return variant name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * get the concrete variant value
	 * 
	 * @return value
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#getVersionTerm()
	 */
	public VersionTerm getVersionTerm()
	{
		return new VersionTerm("0.1.4");
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#isDebugPrint()
	 */
	public boolean isDebugPrint()
	{
		return true;
	}

	/**
	 * set the valiant name
	 * 
	 * @param name
	 *            the valiant name
	 */
	public void setName(final String name)
	{
		this.name = name;
	}

	/**
	 * set the concrete valiant value
	 * 
	 * @param value
	 *            value
	 */
	public void setValue(final String value)
	{
		this.value = value;
	}

	@Override
	public String toString()
	{

		StringBuffer buffer = new StringBuffer();

		buffer.append("<variable> variant definition:");
		buffer.append(SystemUtils.LINE_SEPARATOR);

		buffer.append(" name:");
		buffer.append(this.getName());
		buffer.append("  / value:");
		buffer.append(this.getValue());
		buffer.append(SystemUtils.LINE_SEPARATOR);

		return buffer.toString();
	}

}
