/**
 *   Copyright 2007 Y.Murakamin
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.murakamin.sticker.commands;

import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.commands.util.StickerContextUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * write debug log tag<br/> The log is output by using Jakarta commons loggiing
 * components. The output level is "DEBUG".
 * 
 * @author Y.Murakamin
 */
public class InfoCommand implements Command
{

	private final Log log = LogFactory.getLog(Command.class);

	/**
	 * output text
	 */
	private String text;

	/**
	 * constractor
	 */
	public InfoCommand()
	{
		super();
	}

	/**
	 * The log message is output.
	 * 
	 * @param owner
	 *            connection owner object
	 */
	public void execute(final CommandRunner runner) throws Exception
	{

		log.info(StickerContextUtil.getReplacementString(runner
		        .getStickerContext(), this.getText()));
		runner.run(this);
	}

	/**
	 * get the log message
	 * 
	 * @return log message
	 */
	public String getText()
	{
		return this.text;
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#getVersionTerm()
	 */
	public VersionTerm getVersionTerm()
	{
		return new VersionTerm("0.0.3");
	}

	/**
	 * @see net.murakamin.sticker.commands.ExecutableCommand#isDebugPrint()
	 */
	public boolean isDebugPrint()
	{
		return false;
	}

	/**
	 * set the log message
	 * 
	 * @param txt
	 *            log message
	 */
	public void setText(final String txt)
	{
		this.text = txt;
	}

	@Override
	public String toString()
	{
		return this.text;
	}

}
