/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static List<? extends Object> map2List(Map<String, ? extends Object> map, String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(map.get(string));
        }
        return arrayList;
    }

    public static <T> void mapStringList(Map<String, T> map, String[] stringArray, List<T> list) {
        if (stringArray.length != list.size()) {
            throw new SuperCSVException("The namemapper array and the value list must match in size. Number of columns mismatch number of entries for your map.");
        }
        map.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            if (map.containsKey(string)) {
                throw new SuperCSVException("nameMapper array contains duplicate key \"" + string + "\" cannot map the list...");
            }
            map.put(string, list.get(i));
        }
    }

    public static boolean processStringList(List<? super Object> list, List<? extends Object> list2, CellProcessor[] cellProcessorArray, int n, StringBuilder stringBuilder) throws SuperCSVException {
        if (list2.size() != cellProcessorArray.length) {
            throw new SuperCSVException("The value array (size " + list2.size() + ")  must match the processors array (size " + cellProcessorArray.length + ")." + " You are probably reading a CSV line with a different number of columns than the number of cellprocessors specified...");
        }
        list.clear();
        CSVContext cSVContext = new CSVContext();
        for (int i = 0; i < list2.size(); ++i) {
            if (cellProcessorArray[i] == null) {
                list.add(list2.get(i));
                continue;
            }
            cSVContext.lineNumber = n;
            cSVContext.columnNumber = i;
            list.add(cellProcessorArray[i].execute(list2.get(i), cSVContext));
        }
        return true;
    }

    public static Object[] stringMap(Map<String, ? extends Object> map, String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            objectArray[n++] = map.get(string);
        }
        return objectArray;
    }
}

